/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.util;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class GLSLModifier {
    private static final Pattern BEFORE_FIRST_FUNCTION_PATTERN = Pattern.compile("^(?!#version)\\s*(?<!_)\\b[a-zA-Z_][a-zA-Z0-9_]+\\s+[a-zA-Z_][a-zA-Z0-9_]+\\s*\\(", 8);
    private static final Pattern FUNCTION_START_PATTERN = Pattern.compile("(\\b\\w+\\b\\s*\\([^)]*\\)\\s*\\{)", 32);
    private static final Pattern FUNCTION_END_PATTERN = Pattern.compile("(\\w+\\s*\\(.*?\\)\\s*\\{.*?)(\\})", 32);

    public static String removeComments(String glslCode) {
        String regex = "/\\*.*?\\*/|//.*?\\n";
        Pattern pattern = Pattern.compile(regex, 32);
        Matcher matcher = pattern.matcher(glslCode);
        return matcher.replaceAll("");
    }

    public static String replaceFunctionContent(String glslCode, String functionName, String newContent) {
        String functionSignaturePattern = "(" + functionName + "\\s*\\(.*?\\)\\s*\\{)";
        Pattern pattern = Pattern.compile(functionSignaturePattern);
        Matcher matcher = pattern.matcher(glslCode);
        if (matcher.find()) {
            String fullFunctionSignature = matcher.group(1);
            int start = matcher.start();
            int end = matcher.end();
            int braceCount = 1;
            for (int i = end; i < glslCode.length(); ++i) {
                if (glslCode.charAt(i) == '{') {
                    ++braceCount;
                } else if (glslCode.charAt(i) == '}') {
                    --braceCount;
                }
                if (braceCount != 0) continue;
                end = i + 1;
                break;
            }
            String beforeFunction = glslCode.substring(0, start);
            String afterFunction = glslCode.substring(end);
            return beforeFunction + fullFunctionSignature + "\n" + newContent + "\n}" + afterFunction;
        }
        return glslCode;
    }

    public static String replaceFunctionCalls(String glslCode, String targetFunctionName, String replacement) {
        String regex = "\\b" + Pattern.quote(targetFunctionName) + "\\b\\(([^()]*|\\([^()]*\\))*\\)";
        return glslCode.replaceAll(regex, replacement);
    }

    public static boolean hasFunction(String glslCode, String functionName) {
        String regex = "(" + Pattern.quote(functionName) + "\\s*\\(.*?\\)\\s*\\{)(.*?)(\\})";
        Pattern pattern = Pattern.compile(regex, 32);
        Matcher matcher = pattern.matcher(glslCode);
        return matcher.find();
    }

    public static String insertBeforeFirstFunction(String glslCode, String content) {
        Matcher matcher = BEFORE_FIRST_FUNCTION_PATTERN.matcher(glslCode);
        if (matcher.find()) {
            glslCode = new StringBuilder(glslCode).insert(matcher.start(), content + "\n").toString();
        }
        return glslCode;
    }

    public static String insertAtFunctionStart(String glslCode, String functionName, String content) {
        Matcher matcher = FUNCTION_START_PATTERN.matcher(glslCode);
        while (matcher.find()) {
            if (!matcher.group().startsWith(functionName)) continue;
            glslCode = new StringBuilder(glslCode).insert(matcher.end(), "\n" + content + "\n").toString();
            break;
        }
        return glslCode;
    }

    public static String insertAtFunctionEnd(String glslCode, String functionName, String content) {
        Matcher matcher = FUNCTION_START_PATTERN.matcher(glslCode);
        while (matcher.find()) {
            int i;
            if (!matcher.group().startsWith(functionName)) continue;
            int functionStart = matcher.end();
            int braceCount = 1;
            for (i = functionStart; i < glslCode.length() && braceCount > 0; ++i) {
                if (glslCode.charAt(i) == '{') {
                    ++braceCount;
                    continue;
                }
                if (glslCode.charAt(i) != '}') continue;
                --braceCount;
            }
            if (braceCount != 0) break;
            glslCode = new StringBuilder(glslCode).insert(i - 1, "\n" + content + "\n").toString();
            break;
        }
        return glslCode;
    }

    public static String replaceVariableReferences(String glslCode, String variableName, String replacement) {
        StringBuilder result = new StringBuilder();
        int bracketCount = 0;
        int lastIndex = 0;
        for (int i = 0; i < glslCode.length(); ++i) {
            char c = glslCode.charAt(i);
            if (c == '{') {
                if (++bracketCount != 1) continue;
                result.append(glslCode, lastIndex, i + 1);
                lastIndex = i + 1;
                continue;
            }
            if (c != '}' || --bracketCount != 0) continue;
            String functionContent = glslCode.substring(lastIndex, i);
            functionContent = functionContent.replaceAll("(?<![\\w\\.])" + variableName + "(?!\\s*=|\\w)", replacement);
            result.append(functionContent);
            result.append(c);
            lastIndex = i + 1;
        }
        result.append(glslCode.substring(lastIndex));
        return result.toString();
    }

    public static String replaceWithinFunctionContent(String glslCode, String functionName, String search, String replace) {
        int functionStart = ((String)glslCode).indexOf(functionName);
        if (functionStart != -1) {
            int braceCount = 0;
            int contentStart = -1;
            int contentEnd = -1;
            for (int i = functionStart; i < ((String)glslCode).length(); ++i) {
                char c = ((String)glslCode).charAt(i);
                if (c == '{') {
                    if (braceCount == 0) {
                        contentStart = i + 1;
                    }
                    ++braceCount;
                    continue;
                }
                if (c != '}' || --braceCount != 0) continue;
                contentEnd = i;
                break;
            }
            if (contentStart != -1 && contentEnd != -1) {
                String functionContent = ((String)glslCode).substring(contentStart, contentEnd);
                String modifiedContent = StringUtils.replace((String)functionContent, (String)search, (String)replace);
                glslCode = ((String)glslCode).substring(0, contentStart) + modifiedContent + ((String)glslCode).substring(contentEnd);
            }
        }
        return glslCode;
    }

    public static String convertToString(List<String> oceanInjection) {
        StringBuilder sb = new StringBuilder();
        for (String line : oceanInjection) {
            sb.append(line).append("\n");
        }
        return sb.toString();
    }
}

