/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.PoseStack;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.opengl.Data;
import net.diebuddies.opengl.VAO;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.StarterClient;
import net.diebuddies.physics.ocean.OceanWorld;
import net.diebuddies.physics.verlet.ClothRenderCommand;
import net.diebuddies.physics.verlet.constraints.ModelPartConstraint;
import net.diebuddies.render.MainRenderer;
import net.diebuddies.util.PerformanceTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.lwjgl.opengl.GL32C;

public class ClothRenderer {
    private MainRenderer mainRenderer;
    private double lastRenderPercent;

    public ClothRenderer(MainRenderer mainRenderer) {
        this.mainRenderer = mainRenderer;
    }

    public void render(ClientLevel level, RenderType blockLayerIn, PoseStack viewMatrixStack, double xIn, double yIn, double zInm, Matrix4f projectionMatrix) {
        int i;
        if (level == null) {
            return;
        }
        if (StarterClient.optifabric && PhysicsMod.optifineClothCompat.size() > 0) {
            RenderSystem.m_69482_();
            RenderSystem.m_69461_();
            RenderSystem.m_69464_();
            for (i = 0; i < PhysicsMod.optifineClothCompat.size(); ++i) {
                PhysicsMod.optifineClothCompat.get(i).renderSlow((Level)level);
            }
            PhysicsMod.optifineClothCompat.clear();
            RenderSystem.m_69478_();
        }
        PerformanceTracker.startNoFlush("cloth_rendering");
        blockLayerIn.m_110185_();
        this.mainRenderer.bindProperShader();
        RenderSystem.m_252934_((Matrix4f)projectionMatrix);
        RenderSystem.m_69482_();
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        Minecraft.m_91087_().f_91063_.m_109154_().m_109896_();
        RenderSystem.m_69388_((int)33984);
        this.mainRenderer.resetColor();
        this.mainRenderer.setupShader(RenderSystem.m_157196_());
        VAO.storePreviouslyBoundState();
        RenderSystem.m_69464_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL32C.glVertexAttribI2ui((int)Data.OVERLAY.getAttribute(), (int)0, (int)10);
        GL32C.glVertexAttrib4f((int)Data.COLOR.getAttribute(), (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (StarterClient.optifabric) {
            GL32C.glVertexAttrib2f((int)Data.MID_TEX_COORD_OPTIFINE.getAttribute(), (float)0.0f, (float)0.0f);
        } else {
            GL32C.glVertexAttrib2f((int)Data.MID_TEX_COORD_SHADER.getAttribute(), (float)0.0f, (float)0.0f);
        }
        for (i = 0; i < PhysicsMod.clothRenderFast.size(); ++i) {
            ClothRenderCommand renderCommand = PhysicsMod.clothRenderFast.get(i);
            this.renderFast(level, renderCommand);
        }
        PhysicsMod.clothRenderFast.clear();
        VAO.restorePreviouslyBoundState();
        RenderSystem.m_157196_().m_173362_();
        RenderSystem.m_69388_((int)33984);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69481_();
        blockLayerIn.m_110188_();
        RenderSystem.m_157182_();
        BufferUploader.m_166835_();
        PerformanceTracker.end("cloth_rendering");
    }

    private void renderFast(ClientLevel level, ClothRenderCommand renderCommand) {
        GL32C.glVertexAttribI2ui((int)Data.LIGHT.getAttribute(), (int)(renderCommand.brightness & 0xF0), (int)(renderCommand.brightness >> 16 & 0xF0));
        Vec3 view = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        double renderPercent = Minecraft.m_91087_().m_91296_();
        if (Minecraft.m_91087_().m_91104_()) {
            renderPercent = this.lastRenderPercent;
        } else {
            this.lastRenderPercent = renderPercent;
        }
        PoseStack matrixStack = RenderSystem.m_157191_();
        ShaderInstance shader = RenderSystem.m_157196_();
        matrixStack.m_85836_();
        int glID = renderCommand.textureID;
        RenderSystem.m_69388_((int)33984);
        RenderSystem.m_157453_((int)0, (int)glID);
        RenderSystem.m_69396_((int)glID);
        LivingEntity entity = renderCommand.entity;
        double px = Mth.m_14139_((double)renderPercent, (double)entity.f_19790_, (double)entity.m_20185_());
        double py = Mth.m_14139_((double)renderPercent, (double)entity.f_19791_, (double)entity.m_20186_());
        double pz = Mth.m_14139_((double)renderPercent, (double)entity.f_19792_, (double)entity.m_20189_());
        matrixStack.m_85850_().m_252922_().translation((float)(-view.f_82479_ + px), (float)(-view.f_82480_ + py), (float)(-view.f_82481_ + pz));
        if (ConfigClient.areOceanPhysicsEnabled()) {
            OceanWorld oceanWorld = PhysicsMod.getInstance((Level)level).getPhysicsWorld().getOceanWorld();
            float yRot = Mth.m_14179_((float)((float)renderPercent), (float)entity.f_19859_, (float)entity.m_146908_());
            oceanWorld.computeEntityOffset(matrixStack.m_85850_().m_252922_(), matrixStack.m_85850_().m_252943_(), (Level)level, (Entity)entity, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, yRot, (float)renderPercent);
        }
        renderCommand.modelPart.m_171322_(renderCommand.modelPose);
        ModelPartConstraint.entityTransformation(matrixStack, entity, (float)renderPercent);
        ModelPartConstraint.modelPartTransformation(renderCommand.modelPart, matrixStack);
        Matrix4f transformation = matrixStack.m_85850_().m_252922_();
        this.mainRenderer.setupLighting(transformation, shader, level, true);
        PhysicsMod.viewMatrix.mul((Matrix4fc)transformation, transformation);
        this.mainRenderer.setupModelViewMatrix(shader, transformation, null, true);
        this.mainRenderer.setupPBRTextures();
        this.mainRenderer.setupShaderUniforms(shader);
        if (!renderCommand.onlyRenderPlayer) {
            if (ConfigClient.clothSmoothShading) {
                renderCommand.cloth.vao.render();
            } else {
                renderCommand.cloth.vaoFlatShaded.render();
            }
        }
        if (renderCommand.cloth.playerVAO != null && entity instanceof AbstractClientPlayer) {
            AbstractClientPlayer player = (AbstractClientPlayer)entity;
            glID = Minecraft.m_91087_().m_91097_().m_118506_(player.m_108560_()).m_117963_();
            RenderSystem.m_157453_((int)0, (int)glID);
            RenderSystem.m_69396_((int)glID);
            this.mainRenderer.setupPBRTextures();
            renderCommand.cloth.playerVAO.render();
        }
        matrixStack.m_85849_();
    }
}

