/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.verlet.constraints;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import net.diebuddies.compat.Iris;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.math.Math;
import net.diebuddies.physics.PhysicsWorld;
import net.diebuddies.physics.StarterClient;
import net.diebuddies.physics.verlet.RenderedBufferAccessor;
import net.diebuddies.physics.verlet.VerletHelper;
import net.diebuddies.physics.verlet.VerletPoint;
import net.diebuddies.physics.verlet.VerletQuad;
import net.diebuddies.physics.verlet.VerletSimulation;
import net.diebuddies.physics.verlet.VerletStick;
import net.diebuddies.physics.verlet.constraints.ModelCube;
import net.diebuddies.physics.verlet.constraints.RenderConstraint;
import net.diebuddies.physics.verlet.constraints.VerletConstraint;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.BannerBlock;
import net.minecraft.world.level.block.WallBannerBlock;
import net.minecraft.world.level.block.entity.BannerBlockEntity;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Matrix4d;
import org.joml.Matrix4dc;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;
import org.joml.Vector2f;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.lwjgl.system.MemoryUtil;

public class BannerConstraint
implements VerletConstraint {
    private ModelCube[] partsToCheck;
    private BannerBlockEntity bannerBlock;
    private Matrix4d transformation = new Matrix4d();
    private Matrix4d invTransformation = new Matrix4d();
    private VerletHelper helper = new VerletHelper();
    private Vector3d invPoint = new Vector3d();
    private Vector2f[] tmpUV;
    private Matrix4f[] textureMatrices;
    private List<Pair<Holder<BannerPattern>, DyeColor>> patterns;
    private VertexBuffer vertexBuffer;

    public BannerConstraint(VerletSimulation simulation, BannerBlockEntity bannerBlock, ModelPart pole, ModelPart bar, float tickDelta) {
        int i;
        this.bannerBlock = bannerBlock;
        this.patterns = new ObjectArrayList((Collection)bannerBlock.m_58508_());
        List<VerletConstraint> constraints = simulation.getConstraints();
        for (int i2 = 0; i2 < constraints.size(); ++i2) {
            if (!(constraints.get(i2) instanceof RenderConstraint)) continue;
            constraints.remove(i2--);
        }
        this.partsToCheck = bannerBlock.m_58900_().m_60734_() instanceof BannerBlock ? new ModelCube[]{new ModelCube(pole), new ModelCube(bar)} : new ModelCube[]{new ModelCube(bar)};
        this.calculateTransformation(simulation, tickDelta);
        int capeXPoints = 9;
        int capeYPoints = 17;
        double distance = 0.15000000001500002;
        VerletPoint[][] points = new VerletPoint[capeXPoints][capeYPoints];
        float uvXOff = 0.015625f;
        float uvYOff = 0.015625f;
        float uvXMod = 0.3125f;
        float uvYMod = 0.625f;
        for (int y = 0; y < points[0].length; ++y) {
            for (int x = 0; x < points.length; ++x) {
                Vector3d position = new Vector3d((double)x * distance - (double)capeXPoints * 0.5 * distance + distance * 0.5, (double)y * distance, -0.08928571428571429);
                this.transformation.transformPosition(position);
                VerletPoint point = new VerletPoint(position);
                point.uv.set((float)x / (float)(points.length - 1) * uvXMod + uvXOff, (float)y / (float)(points[0].length - 1) * uvYMod + uvYOff);
                if (y == 0) {
                    point.locked = true;
                }
                points[x][y] = point;
                simulation.addPoint(points[x][y]);
            }
        }
        for (int x = 0; x < points.length; ++x) {
            for (int y = 0; y < points[0].length; ++y) {
                if (x < points.length - 1) {
                    simulation.addStick(new VerletStick(points[x][y], points[x + 1][y]));
                }
                if (y < points[0].length - 1) {
                    simulation.addStick(new VerletStick(points[x][y], points[x][y + 1]));
                }
                if (x >= points.length - 1 || y >= points[0].length - 1) continue;
                simulation.addQuad(new VerletQuad(points[x][y + 1], points[x + 1][y + 1], points[x + 1][y], points[x][y]));
                simulation.addStick(new VerletStick(points[x][y], points[x + 1][y + 1]));
                simulation.addStick(new VerletStick(points[x + 1][y], points[x][y + 1]));
            }
        }
        simulation.calculateNormals();
        simulation.downloadData();
        this.calculateTransformation(simulation, tickDelta);
        List<VerletQuad> quads = simulation.getQuads();
        int drawCalls = java.lang.Math.min(17, this.patterns.size());
        int size = quads.size();
        this.tmpUV = new Vector2f[drawCalls * size * 4];
        this.textureMatrices = new Matrix4f[drawCalls];
        for (i = 0; i < this.tmpUV.length; ++i) {
            this.tmpUV[i] = new Vector2f();
        }
        for (i = 0; i < 17 && i < this.patterns.size(); ++i) {
            Pair<Holder<BannerPattern>, DyeColor> pair = this.patterns.get(i);
            Material bannerMaterial = Sheets.m_234347_((ResourceKey)((ResourceKey)((Holder)pair.getFirst()).m_203543_().get()));
            TextureAtlasSprite sprite = bannerMaterial.m_119204_();
            float minU = sprite.m_118409_();
            float maxU = sprite.m_118410_();
            float minV = sprite.m_118411_();
            float maxV = sprite.m_118412_();
            float xScale = maxU - minU;
            float yScale = maxV - minV;
            this.textureMatrices[i] = new Matrix4f().translate(minU, minV, 0.0f).scale(xScale, yScale, 0.0f);
            for (int j = 0; j < quads.size(); ++j) {
                VerletQuad quad = quads.get(j);
                this.remap(quad.point1.uv, minU, maxU, minV, maxV, this.tmpUV[size * i * 4 + j * 4]);
                this.remap(quad.point2.uv, minU, maxU, minV, maxV, this.tmpUV[size * i * 4 + j * 4 + 1]);
                this.remap(quad.point3.uv, minU, maxU, minV, maxV, this.tmpUV[size * i * 4 + j * 4 + 2]);
                this.remap(quad.point4.uv, minU, maxU, minV, maxV, this.tmpUV[size * i * 4 + j * 4 + 3]);
            }
        }
    }

    private void calculateTransformation(VerletSimulation simulation, float tickDelta) {
        BlockState blockState = this.bannerBlock.m_58900_();
        BlockPos blockPos = this.bannerBlock.m_58899_();
        Vector3d offset = simulation.getOffset();
        Matrix4d test = new Matrix4d();
        if (offset != null) {
            test.translate((double)blockPos.m_123341_() - offset.x, (double)blockPos.m_123342_() - offset.y, (double)blockPos.m_123343_() - offset.z);
        } else {
            test.translate((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_());
        }
        if (blockState.m_60734_() instanceof BannerBlock) {
            test.translate(0.5, 0.5, 0.5);
            blockRotation = (float)(-((Integer)blockState.m_61143_((Property)BannerBlock.f_49007_)).intValue() * 360) / 16.0f;
            test.rotate((Quaternionfc)Axis.f_252436_.m_252977_(blockRotation));
        } else {
            test.translate(0.5, -0.1666666716337204, 0.5);
            blockRotation = -((Direction)blockState.m_61143_((Property)WallBannerBlock.f_57916_)).m_122435_();
            test.rotate((Quaternionfc)Axis.f_252436_.m_252977_(blockRotation));
            test.translate(0.0, -0.3125, -0.4375);
        }
        test.scale(0.6666667, -0.6666667, -0.6666667);
        if (simulation.getOffset() == null) {
            long gameTime = this.bannerBlock.m_58904_().m_46467_();
            float n = ((float)java.lang.Math.floorMod((long)(blockPos.m_123341_() * 7 + blockPos.m_123342_() * 9 + blockPos.m_123343_() * 13) + gameTime, 100L) + tickDelta) / 100.0f;
            float xRot = (-0.0125f + 0.01f * Mth.m_14089_((float)((float)java.lang.Math.PI * 2 * n))) * (float)java.lang.Math.PI;
            double yPos = -32.0;
            test.translate(0.0, yPos / 16.0, 0.0);
            if (xRot != 0.0f) {
                test.rotate((Quaternionfc)Axis.f_252529_.m_252961_(xRot));
            }
        }
        this.transformation.set((Matrix4dc)test);
        this.transformation.invert(this.invTransformation);
    }

    @Override
    public boolean initAsyncData(PhysicsWorld world, VerletSimulation simulation) {
        for (int i = 0; i < this.partsToCheck.length; ++i) {
            this.partsToCheck[i].pose = this.partsToCheck[i].part.m_171308_();
            this.partsToCheck[i].updateHitbox();
        }
        return false;
    }

    @Override
    public void updateBefore(double delta, VerletSimulation simulation) {
    }

    @Override
    public void subStep(double percent, VerletSimulation simulation) {
        this.doCollisionCheck(percent, simulation);
    }

    @Override
    public void updateAfter(double delta, VerletSimulation simulation) {
    }

    private void doCollisionCheck(double percent, VerletSimulation simulation) {
        float enlarge = 0.075f;
        for (int i = 0; i < this.partsToCheck.length; ++i) {
            ModelCube part = this.partsToCheck[i];
            float minX = part.minX - enlarge;
            float minY = part.minY - enlarge;
            float minZ = part.minZ - enlarge;
            float maxX = part.maxX + enlarge;
            float maxY = part.maxY + enlarge;
            float maxZ = part.maxZ + enlarge;
            for (VerletPoint point : simulation.getPoints()) {
                if (point.locked) continue;
                this.invTransformation.transformPosition(this.invPoint.set((Vector3dc)point.position));
                if (!this.helper.movePointOutOfBox(this.invPoint, minX, minY, minZ, maxX, maxY, maxZ)) continue;
                point.position.set((Vector3dc)this.transformation.transformPosition(this.invPoint));
                point.friction = 0.6;
            }
        }
    }

    public void translateAndRotate(PoseStack poseStack, PartPose pose) {
        poseStack.m_85837_((double)pose.f_171405_ / 16.0, (double)pose.f_171406_ / 16.0, (double)pose.f_171407_ / 16.0);
        if (pose.f_171410_ != 0.0f) {
            poseStack.m_252781_(Axis.f_252403_.m_252961_(pose.f_171410_));
        }
        if (pose.f_171409_ != 0.0f) {
            poseStack.m_252781_(Axis.f_252436_.m_252961_(pose.f_171409_));
        }
        if (pose.f_171408_ != 0.0f) {
            poseStack.m_252781_(Axis.f_252529_.m_252961_(pose.f_171408_));
        }
    }

    @Override
    public void renderBefore(PoseStack matrixStack, double delta, VerletSimulation simulation) {
    }

    @Override
    public void renderAfter(PoseStack matrixStack, double delta, VerletSimulation simulation) {
    }

    @Override
    public void render(PoseStack matrixStack, double renderPercent, VerletSimulation simulation) {
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        int brightness = simulation.brightness;
        List<VerletQuad> quads = simulation.getQuads();
        int size = quads.size();
        Matrix4f oldTextureMatrix = RenderSystem.m_252744_();
        if (simulation.getQuads().size() > 0) {
            List<VerletPoint> points = simulation.getPoints();
            for (int i = 0; i < points.size(); ++i) {
                points.get(i).updateRenderPosition(renderPercent);
            }
            BufferBuilder.RenderedBuffer bufferedRenderer = null;
            for (int i = 0; i < 17 && i < this.patterns.size(); ++i) {
                Pair<Holder<BannerPattern>, DyeColor> pair = this.patterns.get(i);
                float[] color = ((DyeColor)pair.getSecond()).m_41068_();
                Material bannerMaterial = Sheets.m_234347_((ResourceKey)((ResourceKey)((Holder)pair.getFirst()).m_203543_().get()));
                TextureAtlasSprite sprite = bannerMaterial.m_119204_();
                if (StarterClient.optifabric) {
                    RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                } else {
                    RenderSystem.m_157429_((float)color[0], (float)color[1], (float)color[2], (float)1.0f);
                }
                int glID = Minecraft.m_91087_().m_91097_().m_118506_(sprite.m_247685_()).m_117963_();
                RenderSystem.m_157453_((int)0, (int)glID);
                RenderSystem.m_69396_((int)glID);
                boolean releaseBuffer = i == 16 || i == this.patterns.size() - 1 || StarterClient.iris && Iris.isExtending();
                int drawCallIndex = i * size * 4;
                if (bufferedRenderer != null) {
                    if (StarterClient.iris && Iris.isExtending()) {
                        RenderSystem.m_253091_((Matrix4f)this.textureMatrices[i]);
                    } else {
                        ByteBuffer buffer = bufferedRenderer.m_231196_();
                        int count = 0;
                        int ccount = 0;
                        int vertexCount = quads.size() * 6;
                        int vertexSize = buffer.capacity() / vertexCount;
                        long pointer = MemoryUtil.memAddress((ByteBuffer)buffer);
                        for (int j = 0; j < quads.size(); ++j) {
                            int multiple = j * 4;
                            int uvIndex = drawCallIndex + multiple;
                            this.updateUV(pointer, vertexSize * count++, this.tmpUV[uvIndex + 3]);
                            this.updateUV(pointer, vertexSize * count++, this.tmpUV[uvIndex + 2]);
                            this.updateUV(pointer, vertexSize * count++, this.tmpUV[uvIndex + 1]);
                            this.updateUV(pointer, vertexSize * count++, this.tmpUV[uvIndex]);
                            this.updateUV(pointer, vertexSize * count++, this.tmpUV[uvIndex + 3]);
                            this.updateUV(pointer, vertexSize * count++, this.tmpUV[uvIndex + 1]);
                            if (!StarterClient.optifabric) continue;
                            this.updateColor(pointer, vertexSize * ccount++, color);
                            this.updateColor(pointer, vertexSize * ccount++, color);
                            this.updateColor(pointer, vertexSize * ccount++, color);
                            this.updateColor(pointer, vertexSize * ccount++, color);
                            this.updateColor(pointer, vertexSize * ccount++, color);
                            this.updateColor(pointer, vertexSize * ccount++, color);
                        }
                    }
                    ((RenderedBufferAccessor)bufferedRenderer).setIgnoreRelease(!releaseBuffer);
                    this.drawWithShader(bufferedRenderer);
                    continue;
                }
                if (StarterClient.iris && Iris.isExtending()) {
                    bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85812_);
                    for (j = 0; j < quads.size(); ++j) {
                        VerletQuad quad = quads.get(j);
                        RenderSystem.m_253091_((Matrix4f)this.textureMatrices[i]);
                        if (ConfigClient.clothSmoothShading) {
                            this.bufferVertex(bufferbuilder, renderPercent, quad.point1.renderPosition, quad.point1.uv, quad.point1.bufferNormal, brightness, color);
                            this.bufferVertex(bufferbuilder, renderPercent, quad.point2.renderPosition, quad.point2.uv, quad.point2.bufferNormal, brightness, color);
                            this.bufferVertex(bufferbuilder, renderPercent, quad.point3.renderPosition, quad.point3.uv, quad.point3.bufferNormal, brightness, color);
                            this.bufferVertex(bufferbuilder, renderPercent, quad.point4.renderPosition, quad.point4.uv, quad.point4.bufferNormal, brightness, color);
                            continue;
                        }
                        this.bufferVertex(bufferbuilder, renderPercent, quad.point1.renderPosition, quad.point1.uv, quad.bufferNormal, brightness, color);
                        this.bufferVertex(bufferbuilder, renderPercent, quad.point2.renderPosition, quad.point2.uv, quad.bufferNormal, brightness, color);
                        this.bufferVertex(bufferbuilder, renderPercent, quad.point3.renderPosition, quad.point3.uv, quad.bufferNormal, brightness, color);
                        this.bufferVertex(bufferbuilder, renderPercent, quad.point4.renderPosition, quad.point4.uv, quad.bufferNormal, brightness, color);
                    }
                } else {
                    bufferbuilder.m_166779_(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.f_85812_);
                    for (j = 0; j < quads.size(); ++j) {
                        VerletQuad quad = quads.get(j);
                        int multiple = j * 4;
                        int uvIndex = drawCallIndex + multiple;
                        if (ConfigClient.clothSmoothShading) {
                            this.bufferVertex(bufferbuilder, renderPercent, quad.point4.renderPosition, this.tmpUV[uvIndex + 3], quad.point4.bufferNormal, brightness, color);
                            this.bufferVertex(bufferbuilder, renderPercent, quad.point3.renderPosition, this.tmpUV[uvIndex + 2], quad.point3.bufferNormal, brightness, color);
                            this.bufferVertex(bufferbuilder, renderPercent, quad.point2.renderPosition, this.tmpUV[uvIndex + 1], quad.point2.bufferNormal, brightness, color);
                            this.bufferVertex(bufferbuilder, renderPercent, quad.point1.renderPosition, this.tmpUV[uvIndex], quad.point1.bufferNormal, brightness, color);
                            this.bufferVertex(bufferbuilder, renderPercent, quad.point4.renderPosition, this.tmpUV[uvIndex + 3], quad.point4.bufferNormal, brightness, color);
                            this.bufferVertex(bufferbuilder, renderPercent, quad.point2.renderPosition, this.tmpUV[uvIndex + 1], quad.point2.bufferNormal, brightness, color);
                            continue;
                        }
                        this.bufferVertex(bufferbuilder, renderPercent, quad.point4.renderPosition, this.tmpUV[uvIndex + 3], quad.bufferNormal, brightness, color);
                        this.bufferVertex(bufferbuilder, renderPercent, quad.point3.renderPosition, this.tmpUV[uvIndex + 2], quad.bufferNormal, brightness, color);
                        this.bufferVertex(bufferbuilder, renderPercent, quad.point2.renderPosition, this.tmpUV[uvIndex + 1], quad.bufferNormal, brightness, color);
                        this.bufferVertex(bufferbuilder, renderPercent, quad.point1.renderPosition, this.tmpUV[uvIndex], quad.bufferNormal, brightness, color);
                        this.bufferVertex(bufferbuilder, renderPercent, quad.point4.renderPosition, this.tmpUV[uvIndex + 3], quad.bufferNormal, brightness, color);
                        this.bufferVertex(bufferbuilder, renderPercent, quad.point2.renderPosition, this.tmpUV[uvIndex + 1], quad.bufferNormal, brightness, color);
                    }
                }
                bufferedRenderer = bufferbuilder.m_231175_();
                ((RenderedBufferAccessor)bufferedRenderer).setIgnoreRelease(!releaseBuffer);
                this.drawWithShader(bufferedRenderer);
            }
        }
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_253091_((Matrix4f)oldTextureMatrix);
        this.vertexBuffer = null;
    }

    public void drawWithShader(BufferBuilder.RenderedBuffer renderedBuffer) {
        if (!RenderSystem.m_69587_()) {
            RenderSystem.m_69879_(() -> this._drawWithShader(renderedBuffer));
        } else {
            this._drawWithShader(renderedBuffer);
        }
    }

    private void _drawWithShader(BufferBuilder.RenderedBuffer renderedBuffer) {
        if (StarterClient.iris && Iris.isExtending() && this.vertexBuffer != null) {
            this.vertexBuffer.m_85921_();
        } else {
            this.vertexBuffer = renderedBuffer.m_231198_().f_85733_().m_231233_();
            this.vertexBuffer.m_85921_();
            this.vertexBuffer.m_231221_(renderedBuffer);
        }
        if (this.vertexBuffer != null) {
            this.vertexBuffer.m_253207_(RenderSystem.m_253073_(), RenderSystem.m_253262_(), RenderSystem.m_157196_());
        }
    }

    private void remap(Vector2f uv, float minU, float maxU, float minV, float maxV, Vector2f dst) {
        dst.set(Math.remap(uv.x, 0.0f, 1.0f, minU, maxU), Math.remap(uv.y, 0.0f, 1.0f, minV, maxV));
    }

    private void bufferVertex(BufferBuilder bufferbuilder, double renderPercent, Vector3d position, Vector2f uv, Vector3d normal, int brightness, float[] color) {
        if (StarterClient.optifabric) {
            bufferbuilder.m_5954_((float)position.x, (float)position.y, (float)position.z, color[0], color[1], color[2], 1.0f, uv.x, uv.y, OverlayTexture.f_118083_, brightness, (float)normal.x, (float)normal.y, (float)normal.z);
        } else {
            bufferbuilder.m_5954_((float)position.x, (float)position.y, (float)position.z, 1.0f, 1.0f, 1.0f, 1.0f, uv.x, uv.y, OverlayTexture.f_118083_, brightness, (float)normal.x, (float)normal.y, (float)normal.z);
        }
    }

    private void updateUV(long pointer, int offset, Vector2f uv) {
        MemoryUtil.memPutFloat((long)(pointer + (long)offset + 16L), (float)uv.x);
        MemoryUtil.memPutFloat((long)(pointer + (long)offset + 20L), (float)uv.y);
    }

    private void updateColor(long pointer, int offset, float[] color) {
        MemoryUtil.memPutByte((long)(pointer + (long)offset + 12L), (byte)((byte)(color[0] * 255.0f)));
        MemoryUtil.memPutByte((long)(pointer + (long)offset + 13L), (byte)((byte)(color[1] * 255.0f)));
        MemoryUtil.memPutByte((long)(pointer + (long)offset + 14L), (byte)((byte)(color[2] * 255.0f)));
    }
}

