/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.settings.mobs;

import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import net.diebuddies.config.ConfigAnimations;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.physics.animation.Animation;
import net.diebuddies.physics.settings.ButtonSettings;
import net.diebuddies.physics.settings.gui.AnimationOption;
import net.diebuddies.physics.settings.gui.legacy.CycleOption;
import net.diebuddies.physics.settings.gui.legacy.LegacyOptionsList;
import net.diebuddies.physics.settings.gui.legacy.ProgressOption;
import net.diebuddies.physics.settings.mobs.MobCustomizeScreen;
import net.diebuddies.physics.settings.mobs.MobPhysicsType;
import net.diebuddies.physics.settings.ux.BaseRenderer;
import net.minecraft.client.Options;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.OptionsSubScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;

public class MobSettingsScreen
extends OptionsSubScreen {
    CycleOption<TypeWrapper> PHYSICS_MOB_CYCLING = CycleOption.create("physicsmod.menu.mob.mobphysics", (Object[])TypeWrapper.values(), model -> Component.m_237115_((String)MobPhysicsType.values()[TypeWrapper.unwrapMainRuleValue(((TypeWrapper)((Object)((Object)model))).ordinal())].toString()), gameOptions -> TypeWrapper.values()[TypeWrapper.wrapMainRuleValue(ConfigClient.mobSetting.type.ordinal())], (gameOptions, option, model) -> {
        TypeWrapper type = (TypeWrapper)((Object)((Object)model));
        ConfigClient.mobSetting.type = MobPhysicsType.values()[TypeWrapper.unwrapMainRuleValue(type.ordinal())];
        ConfigClient.save();
    });
    private static final ProgressOption PHYSICS_LIFETIME_MOBS = new ProgressOption("physicsmod.menu.mob.lifetime", 0.0, 100.0, 0.1f, gameOptions -> ConfigClient.mobSetting.lifetime, (gameOptions, value) -> {
        ConfigClient.mobSetting.lifetime = value;
        ConfigClient.save();
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.mob.lifetime", String.format("%.2f", option.get((Options)gameOptions))));
    private static final ProgressOption PHYSICS_LIFETIME_VARIANCE = new ProgressOption("physicsmod.menu.mob.lifetimevariance", 0.0, 30.0, 0.1f, gameOptions -> ConfigClient.mobSetting.lifetimeVariance, (gameOptions, value) -> {
        ConfigClient.mobSetting.lifetimeVariance = value;
        ConfigClient.save();
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.mob.lifetimevariance", String.format("%.2f", option.get((Options)gameOptions))));
    private static final ProgressOption PHYSICS_RAGDOLL_BREAK_FORCE = new ProgressOption("physicsmod.menu.mob.ragdollbreakforce", 0.0, 4.0, 0.01f, gameOptions -> ConfigClient.jointBreakForce, (gameOptions, value) -> {
        ConfigClient.jointBreakForce = value.floatValue();
        ConfigClient.save();
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.mob.ragdollbreakforce", String.format("%.2f", option.get((Options)gameOptions))), minecraft -> Component.m_237115_((String)"physicsmod.menu.mob.ragdollbreak.info"));
    private static final ProgressOption PHYSICS_RAGDOLL_BREAK_BLOOD = new ProgressOption("physicsmod.menu.mob.ragdollbreakblood", 0.0, 5.0, 0.01f, gameOptions -> ConfigClient.jointBlood, (gameOptions, value) -> {
        ConfigClient.jointBlood = value.floatValue();
        ConfigClient.save();
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.mob.ragdollbreakblood", String.format("%.2f", option.get((Options)gameOptions))), minecraft -> Component.m_237115_((String)"physicsmod.menu.mob.ragdollbreak.info"));
    private static final ProgressOption PHYSICS_RAGDOLL_LIMIT = new ProgressOption("physicsmod.menu.mob.ragdolllimit", 1.0, 256.0, 1.0f, gameOptions -> ConfigClient.mobRagdollLimit, (gameOptions, value) -> {
        ConfigClient.mobRagdollLimit = Math.max(value.intValue(), 1);
        ConfigClient.save();
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.mob.ragdolllimit", Integer.toString((int)option.get((Options)gameOptions))), minecraft -> Component.m_237115_((String)"physicsmod.menu.mob.ragdolllimit.info"));
    private LegacyOptionsList list;

    public MobSettingsScreen(Screen parent, Options options) {
        super(parent, options, (Component)Component.m_237115_((String)"physicsmod.menu.mobs.title"));
    }

    protected void m_7856_() {
        this.list = new LegacyOptionsList(this.f_96541_, this.f_96543_, this.f_96544_, 32, this.f_96544_ - 32, 25);
        Animation animation = ConfigClient.mobSetting.animation;
        long id = -1L;
        for (Long2ObjectMap.Entry entry : ConfigAnimations.animations.long2ObjectEntrySet()) {
            if (!((Animation)entry.getValue()).equals(animation)) continue;
            id = entry.getLongKey();
            break;
        }
        AnimationOption option = new AnimationOption(Language.m_128107_().m_6834_("physicsmod.animation"), id, (Screen)this, particleChange -> {
            ConfigClient.mobSetting.animation = (Animation)ConfigAnimations.animations.get(Long.parseLong((String)particleChange));
            ConfigClient.save();
        }, "default", false);
        this.list.addSmall(this.PHYSICS_MOB_CYCLING, PHYSICS_LIFETIME_MOBS);
        this.list.addSmall(PHYSICS_LIFETIME_VARIANCE, option);
        this.list.addBig(PHYSICS_RAGDOLL_BREAK_FORCE);
        this.list.addBig(PHYSICS_RAGDOLL_BREAK_BLOOD);
        this.list.addBig(PHYSICS_RAGDOLL_LIMIT);
        this.f_96540_.add(this.list);
        this.m_142416_((GuiEventListener)ButtonSettings.builder(this.f_96543_ / 2 - 80, this.f_96544_ - 27, 75, 20, (Component)Component.m_237115_((String)"physicsmod.gui.customize"), button -> this.f_96541_.m_91152_((Screen)new MobCustomizeScreen((Screen)this, this.f_96541_.f_91066_))));
        this.m_142416_((GuiEventListener)ButtonSettings.builder(this.f_96543_ / 2 + 5, this.f_96544_ - 27, 75, 20, CommonComponents.f_130655_, button -> this.f_96541_.m_91152_(this.f_96281_)));
    }

    public void m_86412_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        this.list.m_86412_(matrices, mouseX, mouseY, delta);
        MobSettingsScreen.m_93215_((PoseStack)matrices, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)15, (int)0xFFFFFF);
        super.m_86412_(matrices, mouseX, mouseY, delta);
        BaseRenderer.renderSettingsTooltip(this.list, matrices, mouseX, mouseY, this.f_96543_, this.f_96544_);
    }

    public static enum TypeWrapper {
        RAGDOLL,
        BLOCKY,
        FRACTURED,
        BLOODY,
        OFF,
        RAGDOLL_BREAKING,
        RAGDOLL_BREAKING_BLOOD;


        private static int wrapMainRuleValue(int ordinal) {
            if (ordinal > 4) {
                return ordinal - 1;
            }
            return ordinal;
        }

        private static int unwrapMainRuleValue(int ordinal) {
            if (ordinal > 4) {
                return ordinal + 1;
            }
            return ordinal;
        }
    }
}

