/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.settings.mobs;

import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.settings.cloth.BaseEntry;
import net.diebuddies.physics.settings.gui.EditButton;
import net.diebuddies.physics.settings.gui.legacy.LegacyObjectSelectionList;
import net.diebuddies.physics.settings.mobs.MobEntry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EntityType;

public class MobSelectionList
extends LegacyObjectSelectionList<BaseEntry> {
    public String filter = "";
    public Consumer<String> editMob;
    public boolean hasEditButton;
    private Map<BaseEntry, Button> buttons = new Object2ObjectOpenHashMap();

    public MobSelectionList(Minecraft minecraft, int i, int j, int k, int l, int m, Consumer<String> editMob) {
        super(minecraft, i, j, k, l, m);
        this.editMob = editMob;
        this.hasEditButton = editMob != null;
        this.refreshEntries();
    }

    public MobSelectionList(Minecraft minecraft, int i, int j, int k, int l, int m) {
        this(minecraft, i, j, k, l, m, null);
    }

    public void refreshEntries() {
        this.clearEntries();
        this.buttons = new Object2ObjectOpenHashMap();
        ObjectArrayList ids = new ObjectArrayList();
        for (EntityType<?> type : PhysicsMod.renderers.keySet()) {
            ids.add(EntityType.m_20613_(type).toString());
        }
        Collections.sort(ids);
        MobEntry first = null;
        for (String id : ids) {
            if (!id.toLowerCase().contains(this.filter.toLowerCase())) continue;
            MobEntry entry = new MobEntry((LegacyObjectSelectionList)this, id);
            this.addEntry(entry);
            if (first != null) continue;
            first = entry;
        }
        if (first != null) {
            this.ensureVisible(first);
        }
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        return super.m_6375_(mouseX, mouseY, mouseButton) | this.listButtons(null, mouseX, mouseY, mouseButton, 0.0f, false);
    }

    public boolean listButtons(PoseStack poseStack, double mouseX, double mouseY, int mouseButton, float tickDelta, boolean render) {
        if (this.editMob != null) {
            boolean clicked = false;
            int m = this.getItemCount();
            for (int index = 0; index < m; ++index) {
                int entryY = this.getRowTop(index);
                int p = this.getRowBottomCustom(index);
                if (p < this.y0 || entryY > this.y1) continue;
                int entryHeight = this.itemHeight - 4;
                BaseEntry entry = (BaseEntry)this.getEntry(index);
                Button button = this.buttons.computeIfAbsent(entry, key -> new EditButton(this.getRowRight() + 3, entryY, entryHeight, entryHeight - 1, (Component)Component.m_237113_((String)""), source -> this.editMob.accept((String)entry.getUserData())));
                button.m_252865_(this.getRowRight() + 3);
                button.m_253211_(entryY);
                if (!render) {
                    if (!button.m_6375_(mouseX, mouseY, mouseButton)) continue;
                    return true;
                }
                button.m_86412_(poseStack, (int)mouseX, (int)mouseY, tickDelta);
            }
            return clicked;
        }
        return false;
    }

    private int getRowBottomCustom(int i) {
        return this.getRowTop(i) + this.itemHeight;
    }

    @Override
    protected int getScrollbarPosition() {
        if (this.hasEditButton) {
            return this.width - 20;
        }
        return super.getScrollbarPosition();
    }

    @Override
    protected void renderList(PoseStack poseStack, int x, int scrollAmount, int mouseX, int mouseY, float tickDelta) {
        super.renderList(poseStack, x, scrollAmount, mouseX, mouseY, tickDelta);
        this.listButtons(poseStack, mouseX, mouseY, 0, tickDelta, true);
    }
}

