/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.settings.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.diebuddies.physics.settings.ButtonSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;

public class PopupWidget
extends AbstractWidget {
    private static final int MAX_INFO_WIDTH = 300;
    private String title;
    public List<FormattedCharSequence> info;

    public PopupWidget(String title, int x, int y, int width, int height, Component component) {
        super(x, y, width, height, component);
        this.title = title;
        this.info = Minecraft.m_91087_().f_91062_.m_92923_((FormattedText)Component.m_237113_((String)title), 300);
    }

    public void m_87963_(PoseStack transformation, int mouseX, int mouseY, float delta) {
        AbstractWidget.m_93172_((PoseStack)transformation, (int)this.m_252754_(), (int)this.m_252907_(), (int)this.f_93618_, (int)this.f_93619_, (int)-1090519040);
        transformation.m_252880_(0.0f, 0.0f, 600.0f);
        int lineY = 0;
        for (FormattedCharSequence sequence : this.info) {
            PopupWidget.m_168749_((PoseStack)transformation, (Font)Minecraft.m_91087_().f_91062_, (FormattedCharSequence)sequence, (int)(this.f_93618_ / 2), (int)(this.f_93619_ / 2 - 25 + lineY), (int)0xFFFF55);
            lineY += 10;
        }
    }

    public void m_168797_(NarrationElementOutput var1) {
    }

    public boolean m_6375_(double d, double e, int i) {
        return true;
    }

    public static void create(String title, Screen screen, WidgetCreator creator, WidgetRemover remover, Component yes, Component no, PopupCallback callback) {
        PopupPress yesPress = new PopupPress(remover, callback, PopupResponse.YES);
        PopupPress noPress = new PopupPress(remover, callback, PopupResponse.NO);
        PopupWidget background = new PopupWidget(title, 0, 0, screen.f_96543_, screen.f_96544_, (Component)Component.m_237113_((String)""));
        creator.addWidget(background);
        int yOffset = (background.info.size() - 1) * 10;
        Button noButton = ButtonSettings.builder(screen.f_96543_ / 2 - 90, screen.f_96544_ / 2 + 5 + yOffset, 80, 20, no, noPress);
        creator.addWidget((AbstractWidget)noButton);
        Button yesButton = ButtonSettings.builder(screen.f_96543_ / 2 + 10, screen.f_96544_ / 2 + 5 + yOffset, 80, 20, yes, yesPress);
        creator.addWidget((AbstractWidget)yesButton);
        screen.f_96540_.remove((Object)background);
        screen.f_96540_.remove(noButton);
        screen.f_96540_.remove(yesButton);
        screen.f_96540_.add(0, background);
        screen.f_96540_.add(0, noButton);
        screen.f_96540_.add(0, yesButton);
        yesPress.background = background;
        yesPress.noButton = noButton;
        yesPress.yesButton = yesButton;
        noPress.background = background;
        noPress.noButton = noButton;
        noPress.yesButton = yesButton;
    }

    public static void create(String title, Screen screen, WidgetCreator creator, WidgetRemover remover, PopupCallback callback) {
        PopupWidget.create(title, screen, creator, remover, CommonComponents.f_130657_, CommonComponents.f_130658_, callback);
    }

    private static class PopupPress
    implements Button.OnPress {
        public AbstractWidget background;
        public AbstractWidget noButton;
        public AbstractWidget yesButton;
        private WidgetRemover remover;
        private PopupCallback callback;
        private PopupResponse response;

        public PopupPress(WidgetRemover remover, PopupCallback callback, PopupResponse response) {
            this.remover = remover;
            this.callback = callback;
            this.response = response;
        }

        public void m_93750_(Button button) {
            this.remover.removeWidget(this.background);
            this.remover.removeWidget(this.noButton);
            this.remover.removeWidget(this.yesButton);
            this.callback.popupClosed(this.response);
        }
    }

    public static enum PopupResponse {
        YES,
        NO;

    }

    public static interface WidgetRemover {
        public void removeWidget(AbstractWidget var1);
    }

    public static interface PopupCallback {
        public void popupClosed(PopupResponse var1);
    }

    public static interface WidgetCreator {
        public void addWidget(AbstractWidget var1);
    }
}

