/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.settings.cloth;

import com.google.gson.JsonArray;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.diebuddies.compat.Sodium;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.config.ConfigCloth;
import net.diebuddies.model.ColladaMesh;
import net.diebuddies.physics.DynamicsWorld;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.StarterClient;
import net.diebuddies.physics.settings.ButtonSettings;
import net.diebuddies.physics.settings.cloth.BaseEntry;
import net.diebuddies.physics.settings.cloth.CategorySelectionList;
import net.diebuddies.physics.settings.cloth.ClothConstants;
import net.diebuddies.physics.settings.cloth.ClothEntitySelectionScreen;
import net.diebuddies.physics.settings.cloth.ClothSelectionList;
import net.diebuddies.physics.settings.cloth.PartSelectionList;
import net.diebuddies.physics.settings.gui.legacy.LegacyAbstractSelectionList;
import net.diebuddies.physics.settings.mobs.BoundingBoxGetter;
import net.diebuddies.physics.settings.mobs.MobEntry;
import net.diebuddies.physics.settings.ux.Animatable;
import net.diebuddies.physics.verlet.Cloth;
import net.diebuddies.physics.verlet.ModelPartParent;
import net.diebuddies.physics.verlet.VerletPoint;
import net.diebuddies.physics.verlet.VerletSimulation;
import net.diebuddies.physics.verlet.constraints.ModelPartConstraint;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import org.joml.Matrix4d;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ClothDisplayScreen
extends Screen {
    private static final double ROTATE_SPEED = 6.0;
    private static final double START_ROTATE_SPEED = 25.0;
    private Screen parent;
    private PartSelectionList partList;
    public LegacyAbstractSelectionList<?> activeList;
    private String selectedEntity = "physicsmod:yourself";
    public EntityType<? extends Entity> entityType;
    private ResourceLocation textureLocation;
    private Model model;
    private List<AbstractWidget> bottomWidgets = new ObjectArrayList();
    private Component customTitle;
    private Map<String, VerletSimulation> simulations = new Object2ObjectOpenHashMap();
    private long lastTime;
    private double timeDelta;
    private static final double FIXED_TIME_STEP = 0.016666666666666666;
    private double rotationSpeed = 25.0;
    private double totalRotation;
    private int entityXPosition;
    private Button rotateLeft;
    private Button rotateRight;
    private double startX;
    private double startY;
    private double startZ;
    private double endX;
    private double endY;
    private double endZ;
    private boolean reloadLater;
    @Nullable
    private Map<String, ConfigCloth.ClothList> playerCopy;

    protected ClothDisplayScreen(Screen parent) {
        super((Component)Component.m_237115_((String)"physicsmod.menu.cloth.partselection.title"));
        this.parent = parent;
        this.entityType = EntityType.f_20532_;
        Object2ObjectOpenHashMap toCopy = ConfigCloth.getCustomizationParts("physicsmod:yourself");
        if (toCopy == null) {
            toCopy = new Object2ObjectOpenHashMap();
        }
        this.playerCopy = new Object2ObjectOpenHashMap();
        for (Map.Entry entry : toCopy.entrySet()) {
            this.playerCopy.put((String)entry.getKey(), ((ConfigCloth.ClothList)entry.getValue()).copy());
        }
    }

    protected void m_7856_() {
        super.m_7856_();
        this.reloadLater = !ConfigCloth.clothUpToDate;
        ConfigCloth.isChangingPlayer = true;
        PhysicsMod.loadCloth();
        PhysicsMod.resetClothSimulations();
        this.loadModelAndTexture();
        this.loadCloth();
        this.lastTime = System.nanoTime();
        PhysicsMod.createClothDirectory();
        this.entityXPosition = (int)((double)this.f_96543_ * 0.25);
        this.m_142416_((GuiEventListener)((Button)((Animatable)ButtonSettings.builder(this.entityXPosition - 10, this.f_96544_ - 57, 20, 20, (Component)Component.m_237113_((String)"?"), button -> {
            this.rotationSpeed = 25.0;
        })).setAnimDepth(200.0f)));
        this.rotateLeft = (Button)((Animatable)ButtonSettings.builder(this.entityXPosition - 35, this.f_96544_ - 57, 20, 20, (Component)Component.m_237113_((String)"<"), button -> {})).setAnimDepth(200.0f);
        this.m_142416_((GuiEventListener)this.rotateLeft);
        this.rotateRight = (Button)((Animatable)ButtonSettings.builder(this.entityXPosition + 15, this.f_96544_ - 57, 20, 20, (Component)Component.m_237113_((String)">"), button -> {})).setAnimDepth(200.0f);
        this.m_142416_((GuiEventListener)this.rotateRight);
        this.goToCategoryScreen();
    }

    private void goToCategoryScreen() {
        if (this.activeList != null) {
            this.f_96540_.remove(this.activeList);
        }
        this.customTitle = this.reloadLater ? Component.m_237115_((String)"physicsmod.menu.cloth.downloading.title") : Component.m_237110_((String)"physicsmod.menu.cloth.categoryselection.title", (Object[])new Object[]{ClothDisplayScreen.getEntityName(this.selectedEntity)});
        this.setBottomWidgets(new AbstractWidget[]{ButtonSettings.builder(0, 0, 100, 20, (Component)Component.m_237115_((String)"physicsmod.menu.cloth.selection.changeEntity"), button -> this.f_96541_.m_91152_((Screen)new ClothEntitySelectionScreen(this, this.f_96541_.f_91066_))), ButtonSettings.builder(0, 0, 100, 20, CommonComponents.f_130655_, button -> this.m_7379_())});
        CategorySelectionList list = new CategorySelectionList(this, this.f_96541_, this.f_96543_, this.f_96544_, 32, this.f_96544_ - 32, 25);
        this.f_96540_.add(list);
        this.activeList = list;
    }

    private void goToPartsScreen() {
        if (this.activeList != null) {
            this.f_96540_.remove(this.activeList);
        }
        this.customTitle = Component.m_237110_((String)"physicsmod.menu.cloth.partselection.title", (Object[])new Object[]{ClothDisplayScreen.getEntityName(this.selectedEntity)});
        this.setBottomWidgets(new AbstractWidget[]{ButtonSettings.builder(0, 0, 100, 20, (Component)Component.m_237115_((String)"physicsmod.menu.cloth.selection.changeEntity"), button -> this.f_96541_.m_91152_((Screen)new ClothEntitySelectionScreen(this, this.f_96541_.f_91066_))), ButtonSettings.builder(0, 0, 100, 20, CommonComponents.f_130655_, button -> this.m_7379_())});
        this.partList = new PartSelectionList(this, this.f_96541_, this.f_96543_, this.f_96544_, 32, this.f_96544_ - 32, 25);
        this.f_96540_.add(this.partList);
        this.activeList = this.partList;
    }

    public void goToClothScreen(String selectedCategory) {
        if (this.activeList != null) {
            this.f_96540_.remove(this.activeList);
        }
        this.customTitle = Component.m_237110_((String)"physicsmod.menu.cloth.clothselection.title", (Object[])new Object[]{ClothDisplayScreen.getEntityName(this.selectedEntity)});
        this.setBottomWidgets(new AbstractWidget[]{ButtonSettings.builder(0, this.f_96544_ - 27, 100, 20, (Component)Component.m_237115_((String)"physicsmod.menu.cloth.selection.openFolder"), button -> Util.m_137581_().m_137644_(PhysicsMod.CLOTH_DIRECTORY.toFile())), ButtonSettings.builder(0, this.f_96544_ - 27, 100, 20, (Component)Component.m_237115_((String)"physicsmod.gui.select"), button -> this.goToCategoryScreen())});
        ClothSelectionList list = new ClothSelectionList(this, selectedCategory, this.f_96541_, this.f_96543_, this.f_96544_, 32, this.f_96544_ - 32, 25);
        this.f_96540_.add(list);
        this.activeList = list;
    }

    public static String getEntityName(String selectedEntity) {
        if (selectedEntity.equals("physicsmod:yourself")) {
            return Language.m_128107_().m_6834_("physicsmod.menu.cloth.clothselection.yourself");
        }
        if (selectedEntity.equals("minecraft:player")) {
            return Language.m_128107_().m_6834_("physicsmod.menu.cloth.clothselection.allPlayers");
        }
        return selectedEntity.replace("physicsmod:player:", "");
    }

    public void setBottomWidgets(AbstractWidget ... newWidgets) {
        for (AbstractWidget widget : this.bottomWidgets) {
            this.m_169411_((GuiEventListener)widget);
        }
        this.bottomWidgets.clear();
        int width = 100;
        int padding = 10;
        int y = this.f_96544_ - 27;
        int centerX = this.f_96543_ / 2;
        int offsetX = centerX - (width * newWidgets.length + (newWidgets.length - 1) * padding) / 2;
        for (AbstractWidget widget : newWidgets) {
            this.bottomWidgets.add(widget);
            widget.m_253211_(y);
            widget.m_252865_(offsetX);
            widget.m_93674_(width);
            this.m_142416_((GuiEventListener)widget);
            offsetX += width + padding;
        }
    }

    public void m_86412_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        this.activeList.m_86412_(matrices, mouseX, mouseY, delta);
        ClothDisplayScreen.m_93215_((PoseStack)matrices, (Font)this.f_96547_, (Component)this.customTitle, (int)(this.f_96543_ / 2), (int)15, (int)0xFFFFFF);
        if (this.rotateLeft.m_198029_()) {
            this.rotationSpeed = -6.0;
        } else if (this.rotateRight.m_198029_()) {
            this.rotationSpeed = 6.0;
        }
        this.updateCloth();
        this.renderEntity();
        super.m_86412_(matrices, mouseX, mouseY, delta);
    }

    public void m_86600_() {
        if (this.reloadLater && ConfigCloth.clothUpToDate) {
            this.m_7856_();
        }
        super.m_86600_();
    }

    private void updateCloth() {
        long time = System.nanoTime();
        double passedTime = (double)(System.nanoTime() - this.lastTime) / 1.0E9;
        this.lastTime = time;
        this.timeDelta += passedTime;
        while (this.timeDelta >= 0.016666666666666666) {
            this.timeDelta -= 0.016666666666666666;
            this.rotationSpeed = org.joml.Math.lerp((double)this.rotationSpeed, (double)0.0, (double)0.06);
            this.rotateEntity();
            for (VerletSimulation simulation : this.simulations.values()) {
                this.rotateCloth(simulation);
                simulation.update(null, 0.016666666666666666);
            }
        }
    }

    private void rotateCloth(VerletSimulation simulation) {
        PoseStack stack = new PoseStack();
        stack.m_85850_().m_252922_().rotate((Quaternionfc)new Quaternionf().rotationXYZ(0.0f, (float)(-Math.toRadians(this.totalRotation)), 0.0f));
        simulation.getConstraint(ModelPartConstraint.class).modelPartTransformation(stack);
        Matrix4d rotation = new Matrix4d((Matrix4fc)stack.m_85850_().m_252922_());
        ColladaMesh mesh = simulation.cloth.mesh;
        int size = mesh.positions.size();
        List<Vector3f> positions = mesh.positions;
        List<VerletPoint> points = simulation.getPoints();
        Vector3d tmp = new Vector3d();
        for (int i = 0; i < points.size() && i < size; ++i) {
            VerletPoint point = points.get(i);
            Vector3f pos = positions.get(i);
            tmp.set((double)pos.x, (double)pos.y, (double)pos.z);
            if (point.locked) {
                rotation.transformPosition(tmp);
                point.position.set((Vector3dc)tmp);
                continue;
            }
            if (point.softRestriction == null) continue;
            rotation.transformPosition(tmp);
            point.softRestriction.set((Vector3dc)tmp);
        }
    }

    private void rotateEntity() {
        this.totalRotation += this.rotationSpeed;
    }

    private void renderEntity() {
        PoseStack matrices = RenderSystem.m_157191_();
        float scale = (float)this.f_96544_ * 0.215f;
        double xPosition = this.entityXPosition;
        double yPosition = (double)this.f_96544_ * 0.5;
        float depth = 100.0f;
        matrices.m_85836_();
        matrices.m_85837_(xPosition, yPosition, (double)depth);
        matrices.m_85841_(scale, scale, scale);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69482_();
        Minecraft.m_91087_().f_91063_.m_109154_().m_109896_();
        Lighting.m_166384_();
        RenderSystem.m_69478_();
        RenderSystem.m_69481_();
        double mobWidth = this.endX - this.startX;
        double mobHeight = this.endY - this.startY;
        double mobDepth = this.endZ - this.startZ;
        float mobScale = -1.0f / (float)Math.max(mobWidth, Math.max(mobHeight, mobDepth)) * 2.0f;
        matrices.m_85841_(mobScale, mobScale, mobScale);
        matrices.m_85837_(-mobWidth * 0.5 - this.startX, -mobHeight * 0.5 + this.endY, -mobDepth * 0.5 - this.startZ);
        matrices.m_252781_(new Quaternionf().rotationXYZ((float)Math.toRadians(-25.0), (float)Math.toRadians(this.totalRotation), (float)Math.toRadians(180.0)));
        RenderSystem.m_157182_();
        try {
            RenderType renderType = RenderType.m_110452_((ResourceLocation)this.textureLocation);
            if (this.partList != null && this.partList.getHovered() != null) {
                String selected = (String)((BaseEntry)this.partList.getHovered()).getUserData();
                for (ModelPart part : ClothConstants.getModelParts(this.model)) {
                    if (selected.equals(((ModelPartParent)part).physicsmod$getName())) {
                        part.f_104207_ = true;
                        continue;
                    }
                    part.f_104207_ = false;
                }
            }
            ClothConstants.hideProperParts(this.selectedEntity, this.model);
            MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
            VertexConsumer vertexConsumer = bufferSource.m_6299_(renderType);
            this.model.m_7695_(new PoseStack(), vertexConsumer, 0xF000F0, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 0.0f);
            bufferSource.m_109911_();
            for (ModelPart part : ClothConstants.getModelParts(this.model)) {
                part.f_104207_ = !part.f_104207_;
            }
            ClothConstants.hideProperParts(this.selectedEntity, this.model);
            renderType = RenderType.m_110473_((ResourceLocation)this.textureLocation);
            vertexConsumer = bufferSource.m_6299_(renderType);
            this.model.m_7695_(new PoseStack(), vertexConsumer, 0xF000F0, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 0.175f);
            bufferSource.m_109911_();
            for (ModelPart part : ClothConstants.getModelParts(this.model)) {
                part.f_104207_ = true;
            }
        }
        catch (Exception renderType) {
            // empty catch block
        }
        ShaderInstance shader = RenderSystem.m_157196_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157427_(GameRenderer::m_172658_);
        RenderSystem.m_69482_();
        Minecraft.m_91087_().f_91063_.m_109154_().m_109896_();
        Lighting.m_166384_();
        RenderSystem.m_69464_();
        RenderSystem.m_69388_((int)33984);
        this.renderStaticCloth(matrices);
        matrices.m_85849_();
        matrices.m_85836_();
        matrices.m_85837_(xPosition, yPosition, (double)depth);
        matrices.m_85841_(scale, scale, scale);
        matrices.m_85841_(mobScale, mobScale, mobScale);
        matrices.m_85837_(-mobWidth * 0.5 - this.startX, -mobHeight * 0.5 + this.endY, -mobDepth * 0.5 - this.startZ);
        matrices.m_252781_(new Quaternionf().rotationXYZ((float)Math.toRadians(-25.0), 0.0f, (float)Math.toRadians(180.0)));
        RenderSystem.m_157182_();
        this.renderCloth(matrices);
        matrices.m_85849_();
        RenderSystem.m_157182_();
        Lighting.m_84931_();
        RenderSystem.m_157427_(() -> shader);
    }

    private void renderCloth(PoseStack matrices) {
        for (VerletSimulation simulation : this.simulations.values()) {
            int brightness;
            int glID = simulation.textureID;
            RenderSystem.m_157453_((int)0, (int)glID);
            RenderSystem.m_69396_((int)glID);
            simulation.brightness = brightness = 0xF00000;
            if (!simulation.cloth.rules.isDynamic()) continue;
            simulation.render(matrices);
        }
    }

    private void renderStaticCloth(PoseStack matrices) {
        for (VerletSimulation simulation : this.simulations.values()) {
            int glID;
            int brightness = 0xF00000;
            matrices.m_85836_();
            simulation.getConstraint(ModelPartConstraint.class).modelPartTransformation(matrices);
            RenderSystem.m_157182_();
            if (!simulation.cloth.rules.isDynamic()) {
                glID = simulation.textureID;
                RenderSystem.m_157453_((int)0, (int)glID);
                RenderSystem.m_69396_((int)glID);
                simulation.cloth.mesh.renderSlow(brightness, ConfigClient.clothSmoothShading);
            }
            if (simulation.cloth.playerMesh != null && this.textureLocation != null) {
                glID = Minecraft.m_91087_().m_91097_().m_118506_(this.textureLocation).m_117963_();
                RenderSystem.m_157453_((int)0, (int)glID);
                RenderSystem.m_69396_((int)glID);
                simulation.cloth.playerMesh.renderSlow(brightness, false);
            }
            matrices.m_85849_();
        }
    }

    public void loadModelAndTexture() {
        LocalPlayer player;
        EntityRenderer renderer = PhysicsMod.renderers.get(this.entityType);
        this.textureLocation = MobEntry.getTextureLocation(renderer, this.entityType);
        this.model = MobEntry.getModel(renderer, this.entityType);
        Model model = this.model;
        if (model instanceof EntityModel) {
            EntityModel entityModel = (EntityModel)model;
            entityModel.f_102610_ = false;
        }
        if (this.entityType == EntityType.f_20532_ && (player = Minecraft.m_91087_().f_91074_) != null) {
            renderer = Minecraft.m_91087_().m_91290_().m_114382_((Entity)player);
            this.textureLocation = MobEntry.getTextureLocation(renderer, this.entityType, (Entity)player);
            this.model = MobEntry.getModel(renderer, this.entityType, (Entity)player);
            Model model2 = this.model;
            if (model2 instanceof EntityModel) {
                EntityModel entityModel = (EntityModel)model2;
                entityModel.f_102610_ = false;
            }
        }
        PhysicsMod.sodiumCatchBoundingBox = true;
        PhysicsMod.sodiumBoundingBox.start.set(Double.MAX_VALUE);
        PhysicsMod.sodiumBoundingBox.end.set(-1.7976931348623157E308);
        try {
            BoundingBoxGetter boundingBox = StarterClient.sodium ? Sodium.getNewBoundingBoxConsumer() : new BoundingBoxGetter();
            this.model.m_7695_(new PoseStack(), (VertexConsumer)boundingBox, 0xF000F0, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 0.0f);
            if (StarterClient.sodium) {
                boundingBox.min = PhysicsMod.sodiumBoundingBox.getMin();
                boundingBox.max = PhysicsMod.sodiumBoundingBox.getMax();
            }
            this.startX = boundingBox.min.x;
            this.endX = boundingBox.max.x;
            this.startY = boundingBox.min.y;
            this.endY = boundingBox.max.y;
            this.startZ = boundingBox.min.z;
            this.endZ = boundingBox.max.z;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        PhysicsMod.sodiumCatchBoundingBox = false;
    }

    public void loadCloth() {
        Map<String, ConfigCloth.ClothList> customizations = ConfigCloth.getCustomizationParts(this.selectedEntity);
        this.simulations = new Object2ObjectOpenHashMap();
        if (customizations == null) {
            return;
        }
        for (Map.Entry<String, ConfigCloth.ClothList> clothParts : customizations.entrySet()) {
            String modelPart = clothParts.getKey();
            ConfigCloth.ClothList clothList = clothParts.getValue();
            for (String clothPart : clothList.getClothPieces()) {
                Cloth cloth = PhysicsMod.cloth.get(clothPart);
                if (cloth == null) continue;
                VerletSimulation simulation = new VerletSimulation(new Vector3d((Vector3fc)DynamicsWorld.DEFAULT_GRAVITY).negate(), 45, 0.92, new Vector3d(0.0));
                ModelPartConstraint modelPartConstraint = new ModelPartConstraint(simulation, cloth.rules.getIgnoreParts(), null, modelPart, this.model);
                modelPartConstraint.setCustomTransformation(matrix -> matrix.m_252781_(new Quaternionf().rotationXYZ(0.0f, (float)(-Math.toRadians(this.totalRotation)), 0.0f)));
                simulation.addConstraint(modelPartConstraint);
                PoseStack modelMatrix = new PoseStack();
                modelMatrix.m_85850_().m_252922_().rotate((Quaternionfc)new Quaternionf().rotationXYZ(0.0f, (float)(-Math.toRadians(this.totalRotation)), 0.0f));
                modelPartConstraint.modelPartTransformation(modelMatrix);
                Matrix4d partTransformation = new Matrix4d((Matrix4fc)modelMatrix.m_85850_().m_252922_());
                int texture = cloth.getTexture(null);
                if (texture == -1) {
                    texture = Minecraft.m_91087_().m_91097_().m_118506_(this.textureLocation).m_117963_();
                }
                simulation.addCloth(cloth, texture, partTransformation, false);
                simulation.setTransformation(partTransformation);
                simulation.setBufferTransformation(partTransformation);
                simulation.updateOffsets();
                simulation.calculateNormals();
                modelPartConstraint.initAsyncData(null, simulation);
                modelPartConstraint.changeInstantly = true;
                modelPartConstraint.updateAfter(0.0, simulation);
                simulation.downloadData();
                this.simulations.put(modelPart + clothPart, simulation);
            }
        }
    }

    public String getSelectedEntity() {
        return this.selectedEntity;
    }

    public void setSelectedEntity(String selectedEntity) {
        this.selectedEntity = selectedEntity;
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.parent);
        ConfigCloth.isChangingPlayer = false;
        Object2ObjectOpenHashMap toCheck = ConfigCloth.getCustomizationParts("physicsmod:yourself");
        if (toCheck == null) {
            toCheck = new Object2ObjectOpenHashMap();
        }
        if (!toCheck.equals(this.playerCopy)) {
            UUID uuid = ConfigCloth.getMinecraftUUID();
            if (uuid != null) {
                String uuidString = uuid.toString();
                ConfigCloth.setCustomizationParts(uuidString, (Map<String, ConfigCloth.ClothList>)toCheck);
                JsonArray array = new JsonArray();
                for (Map.Entry entry : toCheck.entrySet()) {
                    for (String part : ((ConfigCloth.ClothList)entry.getValue()).getClothPieces()) {
                        array.add(part);
                    }
                }
            } else {
                StarterClient.logger.error("Couldn't find player uuid");
            }
        }
        ConfigCloth.save();
        PhysicsMod.resetClothSimulations();
    }
}

