/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.settings.animation;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.diebuddies.math.Math;
import net.diebuddies.opengl.Box;
import net.diebuddies.physics.animation.Animation;
import net.diebuddies.physics.animation.AnimationType;
import net.diebuddies.physics.animation.CurveType;
import net.diebuddies.physics.animation.ParticleSpawn;
import net.diebuddies.physics.settings.ButtonSettings;
import net.diebuddies.physics.settings.animation.ParticleEngineExtension;
import net.diebuddies.physics.settings.animation.ParticleExtension;
import net.diebuddies.physics.settings.ux.Animatable;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import org.joml.Quaternionf;

public class ParticleDisplayScreen
extends Screen {
    public static final ResourceLocation STONE_TEXTURE = new ResourceLocation("minecraft:textures/block/stone.png");
    public Screen parent;
    private double xPosition = 70.0;
    private double animationStart;
    private boolean createdParticles;
    public Animation animation;
    private List<Particle> particles;
    private Camera camera = new Camera();
    private long lastTick = System.currentTimeMillis();

    protected ParticleDisplayScreen(Screen parent, Component component) {
        super(component);
        this.parent = parent;
        this.particles = new ObjectArrayList();
        this.animation = new Animation("default", CurveType.Linear, 0.5f);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.startAnimation();
        this.m_142416_((GuiEventListener)((Button)((Animatable)ButtonSettings.builder((int)this.xPosition - 30, this.f_96544_ - 57, 60, 20, (Component)Component.m_237115_((String)"physicsmod.menu.animation.replay"), button -> this.startAnimation())).setAnimDepth(200.0f)));
    }

    public void startAnimation() {
        this.particles.clear();
        this.animationStart = (double)this.animation.speed + 0.5;
        this.createdParticles = false;
    }

    private void createParticles() {
        if (this.createdParticles) {
            return;
        }
        this.createdParticles = true;
        this.particles.clear();
        for (ParticleSpawn spawn : this.animation.particleSpawns) {
            ParticleOptions particleOptions = spawn.particle;
            if (particleOptions == null) continue;
            Map<ResourceLocation, ParticleProvider<?>> provider = ((ParticleEngineExtension)this.f_96541_.f_91061_).getParticleProviders();
            ParticleProvider<?> particleProvider = provider.get(BuiltInRegistries.f_257034_.m_7981_((Object)particleOptions.m_6012_()));
            if (!((double)Math.random() < spawn.spawnChance)) continue;
            for (int i = 0; i < spawn.amount; ++i) {
                double halfSpread = spawn.spread * 0.5;
                double px = (double)Math.random() * spawn.spread - halfSpread;
                double py = (double)Math.random() * spawn.spread - halfSpread;
                double pz = (double)Math.random() * spawn.spread - halfSpread;
                try {
                    Particle particle = particleProvider.m_6966_(particleOptions, null, px, py, pz, spawn.vx, spawn.vy, spawn.vz);
                    ((ParticleExtension)particle).setPhysics(false);
                    ((ParticleExtension)particle).setFakeLight(true);
                    this.particles.add(particle);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (spawn.sound == null) continue;
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)spawn.sound, (float)1.0f));
        }
    }

    public void m_86412_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        ParticleDisplayScreen.m_93215_((PoseStack)matrices, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)15, (int)0xFFFFFF);
        this.renderAnimation(delta);
        super.m_86412_(matrices, mouseX, mouseY, delta);
    }

    public void m_86600_() {
        super.m_86600_();
        this.lastTick = System.currentTimeMillis();
        Iterator<Particle> it = this.particles.iterator();
        while (it.hasNext()) {
            Particle particle = it.next();
            if (!particle.m_107276_()) continue;
            try {
                particle.m_5989_();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (particle.m_107276_()) continue;
            it.remove();
        }
    }

    private void renderAnimation(float delta) {
        float scale = 30.0f;
        PoseStack matrices = RenderSystem.m_157191_();
        float realDelta = java.lang.Math.min(1.0f, (float)(System.currentTimeMillis() - this.lastTick) / 50.0f);
        double startX = -1.0;
        double endX = 1.0;
        double startY = -1.0;
        double endY = 1.0;
        double startZ = -1.0;
        double endZ = 1.0;
        double capeWidth = endX - startX;
        double capeHeight = endY - startY;
        double capeDepth = endZ - startZ;
        matrices.m_85836_();
        matrices.m_85837_(this.xPosition, (double)(this.f_96544_ / 2), 100.0);
        matrices.m_85841_(scale, -scale, scale);
        matrices.m_85837_(-capeWidth * 0.5 - startX, -capeHeight * 0.5 - startY, -capeDepth * 0.5 - startZ);
        matrices.m_85836_();
        matrices.m_252781_(new Quaternionf().rotationXYZ((float)java.lang.Math.toRadians(25.0), (float)java.lang.Math.toRadians(-25.0), 0.0f));
        RenderSystem.m_157182_();
        ShaderInstance shader = RenderSystem.m_157196_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157427_(GameRenderer::m_172658_);
        RenderSystem.m_69482_();
        Minecraft.m_91087_().f_91063_.m_109154_().m_109896_();
        Lighting.m_166384_();
        RenderSystem.m_69388_((int)33984);
        RenderSystem.m_157456_((int)0, (ResourceLocation)STONE_TEXTURE);
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_69464_();
        int brightness = 0xF00000;
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        this.animationStart -= (double)delta * 0.05;
        float despawnScale = this.animation.getCurve().get((float)(this.animationStart / (double)this.animation.speed));
        if (this.animationStart > (double)this.animation.speed) {
            despawnScale = 1.0f;
        } else if (this.animationStart <= 0.0) {
            despawnScale = 0.0f;
        }
        float alpha = 1.0f;
        if (this.animation.despawnType == AnimationType.Vanish) {
            alpha = java.lang.Math.min(1.0f, despawnScale);
            despawnScale = 1.0f;
        } else if (this.animation.despawnType == AnimationType.Shrink_and_Vanish) {
            alpha = java.lang.Math.min(1.0f, despawnScale);
        }
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        bufferbuilder.m_166779_(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.f_85812_);
        int[] indices = Box.INDICES;
        float[] positions = Box.POSITIONS;
        float[] normals = Box.NORMALS;
        float[] uvs = Box.UVS;
        for (int i = 0; i < indices.length; ++i) {
            int index = indices[i];
            float x = positions[index * 3] * 0.5f * despawnScale;
            float y = positions[index * 3 + 1] * 0.5f * despawnScale;
            float z = positions[index * 3 + 2] * 0.5f * despawnScale;
            float nx = -normals[index * 3];
            float ny = -normals[index * 3 + 1];
            float nz = -normals[index * 3 + 2];
            float uvx = uvs[index * 2];
            float uvy = uvs[index * 2 + 1];
            bufferbuilder.m_5954_(x, y, z, 1.0f, 1.0f, 1.0f, 1.0f, uvx, uvy, 0, brightness, nx, ny, nz);
        }
        tesselator.m_85914_();
        if (this.animationStart <= 0.0) {
            this.createParticles();
        }
        matrices.m_85849_();
        RenderSystem.m_157182_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (Particle particle : this.particles) {
            if (!particle.m_107276_()) continue;
            tesselator = Tesselator.m_85913_();
            bufferbuilder = tesselator.m_85915_();
            RenderSystem.m_157427_(GameRenderer::m_172829_);
            ParticleRenderType renderType = particle.m_7556_();
            renderType.m_6505_(bufferbuilder, this.f_96541_.m_91097_());
            particle.m_5744_((VertexConsumer)bufferbuilder, this.camera, realDelta);
            renderType.m_6294_(tesselator);
        }
        matrices.m_85849_();
        RenderSystem.m_157182_();
        Lighting.m_84931_();
        RenderSystem.m_157427_(() -> shader);
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.parent);
    }
}

