/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.settings;

import com.mojang.blaze3d.vertex.PoseStack;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.physics.settings.ButtonSettings;
import net.diebuddies.physics.settings.gui.LabelOption;
import net.diebuddies.physics.settings.gui.PopupWidget;
import net.diebuddies.physics.settings.gui.legacy.CycleOption;
import net.diebuddies.physics.settings.gui.legacy.LegacyOptionsList;
import net.diebuddies.physics.settings.gui.legacy.ProgressOption;
import net.diebuddies.physics.settings.ux.BaseRenderer;
import net.minecraft.client.Options;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.OptionsSubScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;

public class WeatherSettingsScreen
extends OptionsSubScreen {
    private final CycleOption<Boolean> PHYSICS_WIND = CycleOption.createOnOff("physicsmod.menu.weather.windphysics", gameOptions -> ConfigClient.windPhysics, (gameOptions, option, value) -> {
        ConfigClient.windPhysics = value;
        ConfigClient.save();
    });
    private final CycleOption<Boolean> PHYSICS_WEATHER_PARTICLES = CycleOption.createOnOff("physicsmod.menu.weather.particles", gameOptions -> ConfigClient.weatherParticles, (gameOptions, option, value) -> {
        ConfigClient.weatherParticles = value;
        ConfigClient.save();
    });
    private static final ProgressOption PHYSICS_WEATHER_PARTICLES_RAIN_AMOUNT = new ProgressOption("physicsmod.menu.weather.particlesamountrain", 1.0, 30.0, 0.01f, gameOptions -> ConfigClient.weatherRainParticleAmount, (gameOptions, value) -> {
        ConfigClient.weatherRainParticleAmount = value.intValue();
        ConfigClient.save();
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.weather.particlesamountrain", String.format("%.0f", option.get((Options)gameOptions))), minecraft -> Component.m_237115_((String)"physicsmod.menu.weather.particlesamountrain.info"));
    private static final ProgressOption PHYSICS_WEATHER_PARTICLES_THUNDER_AMOUNT = new ProgressOption("physicsmod.menu.weather.particlesamountthunder", 1.0, 30.0, 0.01f, gameOptions -> ConfigClient.weatherThunderParticleAmount, (gameOptions, value) -> {
        ConfigClient.weatherThunderParticleAmount = value.intValue();
        ConfigClient.save();
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.weather.particlesamountthunder", String.format("%.0f", option.get((Options)gameOptions))), minecraft -> Component.m_237115_((String)"physicsmod.menu.weather.particlesamountthunder.info"));
    private static final ProgressOption WEATHER_CLEAR_STRENGTH = new ProgressOption("physicsmod.menu.weather.clearstrength", 0.0, 4.0, 0.01f, gameOptions -> ConfigClient.weatherClearStrength, (gameOptions, value) -> {
        ConfigClient.weatherClearStrength = value.floatValue();
        ConfigClient.save();
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.weather.clearstrength", String.format("%.2f", option.get((Options)gameOptions))), minecraft -> Component.m_237115_((String)"physicsmod.menu.weather.rainstrength.info"));
    private static final ProgressOption WEATHER_RAIN_STRENGTH = new ProgressOption("physicsmod.menu.weather.rainstrength", 0.0, 4.0, 0.01f, gameOptions -> ConfigClient.weatherRainStrength, (gameOptions, value) -> {
        ConfigClient.weatherRainStrength = value.floatValue();
        ConfigClient.save();
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.weather.rainstrength", String.format("%.2f", option.get((Options)gameOptions))), minecraft -> Component.m_237115_((String)"physicsmod.menu.weather.rainstrength.info"));
    private static final ProgressOption WEATHER_THUNDER_STRENGTH = new ProgressOption("physicsmod.menu.weather.thunderstrength", 0.0, 4.0, 0.01f, gameOptions -> ConfigClient.weatherThunderStrength, (gameOptions, value) -> {
        ConfigClient.weatherThunderStrength = value.floatValue();
        ConfigClient.save();
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.weather.thunderstrength", String.format("%.2f", option.get((Options)gameOptions))), minecraft -> Component.m_237115_((String)"physicsmod.menu.weather.rainstrength.info"));
    private static final ProgressOption WEATHER_RAIN_OPACITY = new ProgressOption("physicsmod.menu.weather.rainopacity", 0.0, 1.0, 0.01f, gameOptions -> ConfigClient.particleRainOpacity, (gameOptions, value) -> {
        ConfigClient.particleRainOpacity = value.floatValue();
        ConfigClient.save();
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.weather.rainopacity", String.format("%.2f", option.get((Options)gameOptions))), minecraft -> Component.m_237115_((String)"physicsmod.menu.weather.opacity.info"));
    private static final ProgressOption WEATHER_SNOW_OPACITY = new ProgressOption("physicsmod.menu.weather.snowopacity", 0.0, 1.0, 0.01f, gameOptions -> ConfigClient.particleSnowOpacity, (gameOptions, value) -> {
        ConfigClient.particleSnowOpacity = value.floatValue();
        ConfigClient.save();
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.weather.snowopacity", String.format("%.2f", option.get((Options)gameOptions))), minecraft -> Component.m_237115_((String)"physicsmod.menu.weather.opacity.info"));
    private static final ProgressOption WEATHER_DUST_OPACITY = new ProgressOption("physicsmod.menu.weather.dustopacity", 0.0, 1.0, 0.01f, gameOptions -> ConfigClient.particleDustOpacity, (gameOptions, value) -> {
        ConfigClient.particleDustOpacity = value.floatValue();
        ConfigClient.save();
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.weather.dustopacity", String.format("%.2f", option.get((Options)gameOptions))), minecraft -> Component.m_237115_((String)"physicsmod.menu.weather.opacity.info"));
    private LegacyOptionsList list;

    public WeatherSettingsScreen(Screen parent, Options options) {
        super(parent, options, (Component)Component.m_237115_((String)"physicsmod.menu.weather.title"));
    }

    protected void m_7856_() {
        this.list = new LegacyOptionsList(this.f_96541_, this.f_96543_, this.f_96544_, 32, this.f_96544_ - 32, 25);
        this.list.addSmall(this.PHYSICS_WIND, this.PHYSICS_WEATHER_PARTICLES);
        this.list.addBig(PHYSICS_WEATHER_PARTICLES_RAIN_AMOUNT);
        this.list.addBig(PHYSICS_WEATHER_PARTICLES_THUNDER_AMOUNT);
        this.list.addBig(new LabelOption(Language.m_128107_().m_6834_("physicsmod.menu.weather.strength")));
        this.list.addBig(WEATHER_CLEAR_STRENGTH);
        this.list.addBig(WEATHER_RAIN_STRENGTH);
        this.list.addBig(WEATHER_THUNDER_STRENGTH);
        this.list.addBig(new LabelOption(Language.m_128107_().m_6834_("physicsmod.menu.weather.opacity")));
        this.list.addBig(WEATHER_RAIN_OPACITY);
        this.list.addBig(WEATHER_SNOW_OPACITY);
        this.list.addBig(WEATHER_DUST_OPACITY);
        this.f_96540_.add(this.list);
        this.m_142416_((GuiEventListener)ButtonSettings.builder(this.f_96543_ / 2 + 5, this.f_96544_ - 27, 75, 20, CommonComponents.f_130655_, button -> this.f_96541_.m_91152_(this.f_96281_)));
        this.m_142416_((GuiEventListener)ButtonSettings.builder(this.f_96543_ / 2 - 80, this.f_96544_ - 27, 75, 20, (Component)Component.m_237115_((String)"physicsmod.gui.reset"), button -> PopupWidget.create(Language.m_128107_().m_6834_("physicsmod.menu.weather.reset"), (Screen)this, widget -> this.m_142416_((GuiEventListener)widget), widget -> this.m_169411_((GuiEventListener)widget), response -> {
            if (response == PopupWidget.PopupResponse.YES) {
                ConfigClient.resetWeatherSettings();
                this.list.m_6702_().clear();
                this.f_96541_.m_91152_((Screen)new WeatherSettingsScreen(this.f_96281_, this.f_96282_));
            }
        })));
    }

    public void m_86412_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        this.list.m_86412_(matrices, mouseX, mouseY, delta);
        WeatherSettingsScreen.m_93215_((PoseStack)matrices, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)15, (int)0xFFFFFF);
        super.m_86412_(matrices, mouseX, mouseY, delta);
        BaseRenderer.renderSettingsTooltip(this.list, matrices, mouseX, mouseY, this.f_96543_, this.f_96544_);
    }
}

