/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.settings;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.physics.settings.ButtonSettings;
import net.diebuddies.physics.settings.gui.PopupWidget;
import net.diebuddies.physics.settings.gui.legacy.CycleOption;
import net.diebuddies.physics.settings.gui.legacy.LegacyOptionsList;
import net.diebuddies.physics.settings.gui.legacy.ProgressOption;
import net.diebuddies.physics.settings.ux.BaseRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.OptionsSubScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;

public class SnowSettingsScreen
extends OptionsSubScreen {
    private boolean thicknessChanged = false;
    private final CycleOption<Boolean> PHYSICS_SNOW = CycleOption.createOnOff("physicsmod.menu.snow.snowphysics", gameOptions -> ConfigClient.snowPhysics, (gameOptions, option, value) -> {
        ConfigClient.snowPhysics = value;
        ConfigClient.save();
        Minecraft.m_91087_().f_91060_.m_109818_();
    });
    private final ProgressOption PHYSICS_SNOW_THICKNESS = new ProgressOption("physicsmod.menu.snow.snowthickness", 0.0, 0.5, 0.01f, gameOptions -> ConfigClient.snowThickness, (gameOptions, value) -> {
        ConfigClient.snowThickness = value.floatValue();
        ConfigClient.save();
        this.thicknessChanged = true;
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.snow.snowthickness", String.format("%.2f", option.get((Options)gameOptions))), minecraft -> Component.m_237115_((String)"physicsmod.menu.snow.snowthickness.info"));
    private final CycleOption<Boolean> PHYSICS_SNOW_TRACKS = CycleOption.createOnOff("physicsmod.menu.snow.snowtracks", gameOptions -> ConfigClient.snowTracks, (gameOptions, option, value) -> {
        ConfigClient.snowTracks = value;
        ConfigClient.save();
    });
    private final ProgressOption PHYSICS_SNOW_TRACK_DISTANCE = new ProgressOption("physicsmod.menu.snow.snowtrackdistance", 4.0, 240.0, 0.1f, gameOptions -> ConfigClient.snowTrackDistance, (gameOptions, value) -> {
        ConfigClient.snowTrackDistance = value;
        ConfigClient.save();
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.snow.snowtrackdistance", String.format("%.0f", option.get((Options)gameOptions))), minecraft -> Component.m_237115_((String)"physicsmod.menu.snow.snowtrackdistance.info"));
    private final ProgressOption PHYSICS_SNOW_TRACK_ENTITIES = new ProgressOption("physicsmod.menu.snow.snowtrackentities", 1.0, 60.0, 1.0f, gameOptions -> ConfigClient.snowTrackEntities, (gameOptions, value) -> {
        ConfigClient.snowTrackEntities = value.intValue();
        ConfigClient.save();
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.snow.snowtrackentities", String.format("%.0f", option.get((Options)gameOptions))), minecraft -> Component.m_237115_((String)"physicsmod.menu.snow.snowtrackentities.info"));
    private final CycleOption<Boolean> PHYSICS_GRASSY_SNOW = CycleOption.createOnOff("physicsmod.menu.snow.grasssnowy", gameOptions -> ConfigClient.grassSnowy, (gameOptions, option, value) -> {
        ConfigClient.grassSnowy = value;
        ConfigClient.save();
        Minecraft.m_91087_().f_91060_.m_109818_();
    }).setTooltip(minecraft -> graphicsStatus -> Component.m_237115_((String)"physicsmod.menu.snow.grasssnowy.info"));
    private final CycleOption<Boolean> PHYSICS_SNOW_SMOOTH_SHADING = CycleOption.createOnOff("physicsmod.menu.snow.snowsmoothshading", gameOptions -> ConfigClient.snowSmoothShading, (gameOptions, option, value) -> {
        ConfigClient.snowSmoothShading = value;
        ConfigClient.save();
        Minecraft.m_91087_().f_91060_.m_109818_();
    }).setTooltip(minecraft -> graphicsStatus -> Component.m_237115_((String)"physicsmod.menu.snow.snowsmoothshading.info"));
    private final CycleOption<SnowType> PHYSICS_SNOW_TYPE = CycleOption.create("physicsmod.menu.snow.snowtype", (Object[])SnowType.values(), model -> Component.m_237115_((String)((SnowType)((Object)((Object)model))).toString()), gameOptions -> {
        int val = ConfigClient.snowType;
        if (val >= SnowType.values().length) {
            return SnowType.values()[0];
        }
        return SnowType.values()[val];
    }, (gameOptions, option, model) -> {
        SnowType type = (SnowType)((Object)((Object)model));
        ConfigClient.snowType = type.ordinal();
        ConfigClient.save();
        Minecraft.m_91087_().f_91060_.m_109818_();
    });
    private final CycleOption<SnowQuality> PHYSICS_SNOW_QUALITY = CycleOption.create("physicsmod.menu.snow.snowquality", (Object[])SnowQuality.values(), model -> Component.m_237115_((String)((SnowQuality)((Object)((Object)model))).toString()), gameOptions -> {
        int val = ConfigClient.snowQuality;
        if (val >= SnowQuality.values().length) {
            return SnowQuality.values()[0];
        }
        return SnowQuality.values()[val];
    }, (gameOptions, option, model) -> {
        SnowQuality type = (SnowQuality)((Object)((Object)model));
        ConfigClient.snowQuality = type.ordinal();
        ConfigClient.save();
        Minecraft.m_91087_().f_91060_.m_109818_();
    });
    private final ProgressOption PHYSICS_SNOW_LOD = new ProgressOption("physicsmod.menu.snow.levelofdetail", 0.5, 10.0, 0.01f, gameOptions -> ConfigClient.snowLOD, (gameOptions, value) -> {
        ConfigClient.snowLOD = value.floatValue();
        ConfigClient.save();
        this.thicknessChanged = true;
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.snow.levelofdetail", String.format("%.2f", option.get((Options)gameOptions))), minecraft -> Component.m_237115_((String)"physicsmod.menu.snow.levelofdetail.info"));
    private static final int MAX_INFO_WIDTH = 300;
    private LegacyOptionsList list;
    private List<FormattedCharSequence> info;

    public SnowSettingsScreen(Screen parent, Options options) {
        super(parent, options, (Component)Component.m_237115_((String)"physicsmod.menu.snow.title.pro"));
        this.info = Minecraft.m_91087_().f_91062_.m_92923_((FormattedText)Component.m_237115_((String)"physicsmod.menu.snow.warning"), 300);
        this.PHYSICS_SNOW_QUALITY.setTooltip(minecraft -> graphicsStatus -> Component.m_237115_((String)"physicsmod.menu.snow.snowquality.info"));
    }

    protected void m_7856_() {
        this.list = new LegacyOptionsList(this.f_96541_, this.f_96543_, this.f_96544_, 32, this.f_96544_ - 32, 25);
        this.list.addSmall(this.PHYSICS_SNOW, this.PHYSICS_SNOW_TRACKS);
        this.list.addBig(this.PHYSICS_SNOW_THICKNESS);
        this.list.addBig(this.PHYSICS_SNOW_LOD);
        this.list.addSmall(this.PHYSICS_SNOW_TRACK_ENTITIES, this.PHYSICS_SNOW_TRACK_DISTANCE);
        this.list.addSmall(this.PHYSICS_SNOW_TYPE, this.PHYSICS_SNOW_SMOOTH_SHADING);
        this.list.addSmall(this.PHYSICS_SNOW_QUALITY, this.PHYSICS_GRASSY_SNOW);
        this.f_96540_.add(this.list);
        this.m_142416_((GuiEventListener)ButtonSettings.builder(this.f_96543_ / 2 + 5, this.f_96544_ - 27, 75, 20, CommonComponents.f_130655_, button -> {
            this.m_7379_();
            this.f_96541_.m_91152_(this.f_96281_);
        }));
        this.m_142416_((GuiEventListener)ButtonSettings.builder(this.f_96543_ / 2 - 80, this.f_96544_ - 27, 75, 20, (Component)Component.m_237115_((String)"physicsmod.gui.reset"), button -> PopupWidget.create(Language.m_128107_().m_6834_("physicsmod.menu.snow.reset"), (Screen)this, widget -> this.m_142416_((GuiEventListener)widget), widget -> this.m_169411_((GuiEventListener)widget), response -> {
            if (response == PopupWidget.PopupResponse.YES) {
                ConfigClient.resetSnowSettings();
                this.list.m_6702_().clear();
                this.f_96541_.m_91152_((Screen)new SnowSettingsScreen(this.f_96281_, this.f_96282_));
                Minecraft.m_91087_().f_91060_.m_109818_();
            } else {
                this.list.m_6702_().clear();
                this.f_96541_.m_91152_((Screen)new SnowSettingsScreen(this.f_96281_, this.f_96282_));
            }
        })));
    }

    public void m_86412_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        this.list.m_86412_(matrices, mouseX, mouseY, delta);
        SnowSettingsScreen.m_93215_((PoseStack)matrices, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)15, (int)0xFFFFFF);
        matrices.m_85836_();
        matrices.m_252880_(0.0f, 0.0f, -75.0f);
        int lineY = 0;
        for (FormattedCharSequence sequence : this.info) {
            SnowSettingsScreen.m_168756_((PoseStack)matrices, (Font)this.f_96547_, (FormattedCharSequence)sequence, (int)((this.f_96543_ - 300) / 2), (int)(187 + lineY), (int)0xFFFF55);
            lineY += 10;
        }
        matrices.m_85849_();
        super.m_86412_(matrices, mouseX, mouseY, delta);
        BaseRenderer.renderSettingsTooltip(this.list, matrices, mouseX, mouseY, this.f_96543_, this.f_96544_);
    }

    public void m_7379_() {
        super.m_7379_();
        if (this.thicknessChanged) {
            Minecraft.m_91087_().f_91060_.m_109818_();
        }
    }

    public static enum SnowType {
        Round("physicsmod.enum.snowtype.round"),
        Cube("physicsmod.enum.snowtype.cube");

        private String translationId;

        private SnowType(String translationId) {
            this.translationId = translationId;
        }

        public String toString() {
            return this.translationId;
        }
    }

    public static enum SnowQuality {
        Medium("physicsmod.enum.snowquality.medium"),
        High("physicsmod.enum.snowquality.high");

        private String translationId;

        private SnowQuality(String translationId) {
            this.translationId = translationId;
        }

        public String toString() {
            return this.translationId;
        }
    }
}

