/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.settings;

import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.physics.settings.ButtonSettings;
import net.diebuddies.physics.settings.gui.LabelOption;
import net.diebuddies.physics.settings.gui.PopupWidget;
import net.diebuddies.physics.settings.gui.legacy.LegacyOptionsList;
import net.diebuddies.physics.settings.gui.legacy.ProgressOption;
import net.diebuddies.physics.settings.ux.BaseRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.OptionsSubScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import org.joml.Vector3f;

public class GravityCustomizeSettingsScreen
extends OptionsSubScreen {
    private static String searchText = "";
    private LegacyOptionsList list;

    public GravityCustomizeSettingsScreen(Screen parent, Options options) {
        super(parent, options, (Component)Component.m_237115_((String)"physicsmod.menu.gravity.customize.title"));
    }

    protected void m_7856_() {
        EditBox search = new EditBox(Minecraft.m_91087_().f_91062_, this.f_96543_ / 2 - 160, this.f_96544_ - 27, 100, 20, (Component)Component.m_237113_((String)""));
        this.checkSearchText(searchText, search);
        search.m_94151_(changedText -> this.checkSearchText((String)changedText, search));
        this.m_142416_((GuiEventListener)search);
        this.m_142416_((GuiEventListener)ButtonSettings.builder(this.f_96543_ / 2 - 50, this.f_96544_ - 27, 100, 20, CommonComponents.f_130655_, button -> this.f_96541_.m_91152_(this.f_96281_)));
        this.m_142416_((GuiEventListener)ButtonSettings.builder(this.f_96543_ / 2 + 60, this.f_96544_ - 27, 100, 20, (Component)Component.m_237115_((String)"physicsmod.gui.reset"), button -> PopupWidget.create(Language.m_128107_().m_6834_("physicsmod.menu.gravity.customize.reset"), (Screen)this, widget -> this.m_142416_((GuiEventListener)widget), widget -> this.m_169411_((GuiEventListener)widget), response -> {
            if (response == PopupWidget.PopupResponse.YES) {
                ConfigClient.resetGravities();
                this.list.m_6702_().clear();
                this.f_96541_.m_91152_((Screen)new GravityCustomizeSettingsScreen(this.f_96281_, this.f_96282_));
            }
        })));
    }

    private void checkSearchText(String searchText, EditBox search) {
        GravityCustomizeSettingsScreen.searchText = searchText;
        if (searchText.isEmpty()) {
            search.m_94167_(Language.m_128107_().m_6834_("physicsmod.gui.search"));
        } else {
            search.m_94167_("");
        }
        this.updateGravities(searchText);
    }

    public void m_86412_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        this.list.m_86412_(matrices, mouseX, mouseY, delta);
        GravityCustomizeSettingsScreen.m_93215_((PoseStack)matrices, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)15, (int)0xFFFFFF);
        super.m_86412_(matrices, mouseX, mouseY, delta);
        BaseRenderer.renderSettingsTooltip(this.list, matrices, mouseX, mouseY, this.f_96543_, this.f_96544_);
    }

    public void updateGravities(String matcher) {
        if (this.list != null) {
            this.f_96540_.remove((Object)this.list);
        }
        this.list = new LegacyOptionsList(this.f_96541_, this.f_96543_, this.f_96544_, 32, this.f_96544_ - 32, 25);
        this.f_96540_.add(this.list);
        ObjectArrayList ids = new ObjectArrayList();
        for (String id : ConfigClient.customizedGravities.keySet()) {
            ids.add(id);
        }
        Collections.sort(ids);
        for (String id : ids) {
            if (!id.toLowerCase().contains(matcher.toLowerCase())) continue;
            ProgressOption gravityX = new ProgressOption("physicsmod.menu.gravity.gravityx", -50.0, 50.0, 0.1f, gameOptions -> ConfigClient.getGravity((String)id).x, (gameOptions, value) -> {
                Vector3f val = ConfigClient.getGravity(id);
                val.x = value.floatValue();
                ConfigClient.setGravity(id, val);
                ConfigClient.save();
            }, (gameOptions, option) -> option.customFormat("physicsmod.menu.gravity.gravityx", String.format("%.2f", option.get((Options)gameOptions))));
            ProgressOption gravityY = new ProgressOption("physicsmod.menu.gravity.gravityy", -50.0, 50.0, 0.1f, gameOptions -> ConfigClient.getGravity((String)id).y, (gameOptions, value) -> {
                Vector3f val = ConfigClient.getGravity(id);
                val.y = value.floatValue();
                ConfigClient.setGravity(id, val);
                ConfigClient.save();
            }, (gameOptions, option) -> option.customFormat("physicsmod.menu.gravity.gravityy", String.format("%.2f", option.get((Options)gameOptions))));
            ProgressOption gravityZ = new ProgressOption("physicsmod.menu.gravity.gravityz", -50.0, 50.0, 0.1f, gameOptions -> ConfigClient.getGravity((String)id).z, (gameOptions, value) -> {
                Vector3f val = ConfigClient.getGravity(id);
                val.z = value.floatValue();
                ConfigClient.setGravity(id, val);
                ConfigClient.save();
            }, (gameOptions, option) -> option.customFormat("physicsmod.menu.gravity.gravityz", String.format("%.2f", option.get((Options)gameOptions))));
            ProgressOption buoyancyX = new ProgressOption("physicsmod.menu.gravity.buoyancyx", -50.0, 50.0, 0.1f, gameOptions -> ConfigClient.getBuoyancy((String)id).x, (gameOptions, value) -> {
                Vector3f val = ConfigClient.getBuoyancy(id);
                val.x = value.floatValue();
                ConfigClient.setBuoyancy(id, val);
                ConfigClient.save();
            }, (gameOptions, option) -> option.customFormat("physicsmod.menu.gravity.buoyancyx", String.format("%.2f", option.get((Options)gameOptions))));
            ProgressOption buoyancyY = new ProgressOption("physicsmod.menu.gravity.buoyancyy", -50.0, 50.0, 0.1f, gameOptions -> ConfigClient.getBuoyancy((String)id).y, (gameOptions, value) -> {
                Vector3f val = ConfigClient.getBuoyancy(id);
                val.y = value.floatValue();
                ConfigClient.setBuoyancy(id, val);
                ConfigClient.save();
            }, (gameOptions, option) -> option.customFormat("physicsmod.menu.gravity.buoyancyy", String.format("%.2f", option.get((Options)gameOptions))));
            ProgressOption buoyancyZ = new ProgressOption("physicsmod.menu.gravity.buoyancyz", -50.0, 50.0, 0.1f, gameOptions -> ConfigClient.getBuoyancy((String)id).z, (gameOptions, value) -> {
                Vector3f val = ConfigClient.getBuoyancy(id);
                val.z = value.floatValue();
                ConfigClient.setBuoyancy(id, val);
                ConfigClient.save();
            }, (gameOptions, option) -> option.customFormat("physicsmod.menu.gravity.buoyancyz", String.format("%.2f", option.get((Options)gameOptions))));
            this.list.addBig(new LabelOption(id));
            this.list.addSmall(gravityX, buoyancyX);
            this.list.addSmall(gravityY, buoyancyY);
            this.list.addSmall(gravityZ, buoyancyZ);
        }
    }
}

