/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.settings;

import com.mojang.blaze3d.vertex.PoseStack;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.physics.settings.ButtonSettings;
import net.diebuddies.physics.settings.GravityCustomizeSettingsScreen;
import net.diebuddies.physics.settings.gui.legacy.CycleOption;
import net.diebuddies.physics.settings.gui.legacy.LegacyOptionsList;
import net.diebuddies.physics.settings.gui.legacy.ProgressOption;
import net.diebuddies.physics.settings.ux.BaseRenderer;
import net.minecraft.client.Options;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.OptionsSubScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;

public class GeneralSettingsScreen
extends OptionsSubScreen {
    private static final ProgressOption PHYSICS_MAX_OBJECTS = new ProgressOption("physicsmod.menu.general.maxphysicsobjects", 10.0, 30000.0, 1.0f, gameOptions -> ConfigClient.maxPhysicsObjects, (gameOptions, value) -> {
        ConfigClient.maxPhysicsObjects = value.intValue();
        ConfigClient.save();
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.general.maxphysicsobjects", Integer.toString((int)option.get((Options)gameOptions))));
    private static final ProgressOption CPU_THREADS = new ProgressOption("physicsmod.menu.general.cputhreads", 1.0, Runtime.getRuntime().availableProcessors(), 1.0f, gameOptions -> ConfigClient.cpuThreads, (gameOptions, value) -> {
        ConfigClient.cpuThreads = Math.max(value.intValue(), 1);
        ConfigClient.save();
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.general.cputhreads", Integer.toString((int)option.get((Options)gameOptions))), minecraft -> Component.m_237115_((String)"physicsmod.menu.general.cputhreads.info"));
    private static final CycleOption<Boolean> MINECRAFT_BREAK_PARTICLES = CycleOption.createOnOff("physicsmod.menu.general.minecraftblockbreakparticles", gameOptions -> ConfigClient.minecraftBlockBreakParticles, (gameOptions, option, value) -> {
        ConfigClient.minecraftBlockBreakParticles = value;
        ConfigClient.save();
    });
    private static final CycleOption<Boolean> PVP_COMPATIBILITY = CycleOption.createOnOff("physicsmod.menu.general.pvpservercompatibility", gameOptions -> ConfigClient.pvpServerCompatibility, (gameOptions, option, value) -> {
        ConfigClient.pvpServerCompatibility = value;
        ConfigClient.save();
    }).setTooltip(minecraft -> graphicsStatus -> Component.m_237115_((String)"physicsmod.menu.general.pvpservercompatibility.info"));
    private static final CycleOption<Boolean> CRACK_PARTICLES = CycleOption.createOnOff("physicsmod.menu.general.crackphysicsparticles", gameOptions -> ConfigClient.crackPhysicsParticles, (gameOptions, option, value) -> {
        ConfigClient.crackPhysicsParticles = value;
        ConfigClient.save();
    }).setTooltip(minecraft -> graphicsStatus -> Component.m_237115_((String)"physicsmod.menu.general.crackphysicsparticles.info"));
    private static final CycleOption<Boolean> SPRINTING_PARTICLES = CycleOption.createOnOff("physicsmod.menu.general.sprintingphysicsparticles", gameOptions -> ConfigClient.sprintingPhysicsParticles, (gameOptions, option, value) -> {
        ConfigClient.sprintingPhysicsParticles = value;
        ConfigClient.save();
    }).setTooltip(minecraft -> graphicsStatus -> Component.m_237115_((String)"physicsmod.menu.general.sprintingphysicsparticles.info"));
    private static final CycleOption<Boolean> EATING_PARTICLES = CycleOption.createOnOff("physicsmod.menu.general.eatingphysicsparticles", gameOptions -> ConfigClient.eatingPhysicsParticles, (gameOptions, option, value) -> {
        ConfigClient.eatingPhysicsParticles = value;
        ConfigClient.save();
    }).setTooltip(minecraft -> graphicsStatus -> Component.m_237115_((String)"physicsmod.menu.general.eatingphysicsparticles.info"));
    private static final CycleOption<Boolean> SERVER_BLOCK_PARTICLES = CycleOption.createOnOff("physicsmod.menu.general.serverblockPhysicsparticles", gameOptions -> ConfigClient.serverBlockPhysicsParticles, (gameOptions, option, value) -> {
        ConfigClient.serverBlockPhysicsParticles = value;
        ConfigClient.save();
    }).setTooltip(minecraft -> graphicsStatus -> Component.m_237115_((String)"physicsmod.menu.general.serverblockPhysicsparticles.info"));
    private static final ProgressOption PHYSICS_LIFETIME_CRACK = new ProgressOption("physicsmod.menu.general.particlelifetimeparticles", 0.0, 100.0, 0.1f, gameOptions -> ConfigClient.particleLifetimeParticles, (gameOptions, value) -> {
        ConfigClient.particleLifetimeParticles = value;
        ConfigClient.save();
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.general.particlelifetimeparticles", String.format("%.2f", option.get((Options)gameOptions))));
    private static final ProgressOption PHYSICS_LIFETIME_VARIANCE_CRACK = new ProgressOption("physicsmod.menu.general.particlelifetimevarianceparticles", 0.0, 30.0, 0.1f, gameOptions -> ConfigClient.particleLifetimeVarianceParticles, (gameOptions, value) -> {
        ConfigClient.particleLifetimeVarianceParticles = value;
        ConfigClient.save();
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.general.particlelifetimevarianceparticles", String.format("%.2f", option.get((Options)gameOptions))));
    private static final CycleOption<Boolean> PHYSICS_ITEMS = CycleOption.createOnOff("physicsmod.menu.items.itemphysics", gameOptions -> ConfigClient.itemPhysics, (gameOptions, option, value) -> {
        ConfigClient.itemPhysics = value;
        ConfigClient.save();
    });
    private static final ProgressOption PHYSICS_ITEMS_ROTATION = new ProgressOption("physicsmod.menu.items.rotation", 0.0, 2.0, 0.01f, gameOptions -> ConfigClient.itemRotationSpeed, (gameOptions, value) -> {
        ConfigClient.itemRotationSpeed = value.floatValue();
        ConfigClient.save();
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.items.rotation", String.format("%.2f", option.get((Options)gameOptions))));
    private LegacyOptionsList list;

    public GeneralSettingsScreen(Screen parent, Options options) {
        super(parent, options, (Component)Component.m_237115_((String)"physicsmod.menu.general.title"));
    }

    protected void m_7856_() {
        this.list = new LegacyOptionsList(this.f_96541_, this.f_96543_, this.f_96544_, 32, this.f_96544_ - 32, 25);
        this.list.addSmall(PHYSICS_MAX_OBJECTS, MINECRAFT_BREAK_PARTICLES);
        this.list.addBig(PHYSICS_ITEMS);
        this.list.addBig(PHYSICS_ITEMS_ROTATION);
        this.list.addBig(CPU_THREADS);
        this.list.addBig(PVP_COMPATIBILITY);
        this.list.addSmall(CRACK_PARTICLES, SPRINTING_PARTICLES);
        this.list.addSmall(EATING_PARTICLES, SERVER_BLOCK_PARTICLES);
        this.list.addSmall(PHYSICS_LIFETIME_CRACK, PHYSICS_LIFETIME_VARIANCE_CRACK);
        this.f_96540_.add(this.list);
        this.m_142416_((GuiEventListener)ButtonSettings.builder(this.f_96543_ / 2 - 80, this.f_96544_ - 27, 75, 20, (Component)Component.m_237115_((String)"physicsmod.gui.gravity"), button -> this.f_96541_.m_91152_((Screen)new GravityCustomizeSettingsScreen((Screen)this, this.f_96541_.f_91066_))));
        this.m_142416_((GuiEventListener)ButtonSettings.builder(this.f_96543_ / 2 + 5, this.f_96544_ - 27, 75, 20, CommonComponents.f_130655_, button -> this.f_96541_.m_91152_(this.f_96281_)));
    }

    public void m_86412_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        this.list.m_86412_(matrices, mouseX, mouseY, delta);
        GeneralSettingsScreen.m_93215_((PoseStack)matrices, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)15, (int)0xFFFFFF);
        super.m_86412_(matrices, mouseX, mouseY, delta);
        BaseRenderer.renderSettingsTooltip(this.list, matrices, mouseX, mouseY, this.f_96543_, this.f_96544_);
    }
}

