/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.mixins.ocean;

import java.util.Optional;
import net.coderbot.iris.shaderpack.ProgramSource;
import net.diebuddies.compat.Iris;
import net.diebuddies.physics.ocean.ProgramSourceOcean;
import net.diebuddies.physics.ocean.ShaderInjection;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ProgramSource.class}, remap=false)
public class MixinProgramSource
implements ProgramSourceOcean {
    @Shadow
    @Final
    private String vertexSource;
    @Shadow
    @Final
    private String geometrySource;
    @Shadow
    @Final
    private String fragmentSource;
    @Unique
    private boolean vertexSupportingOcean;
    @Unique
    private boolean geometrySupportingOcean;
    @Unique
    private boolean fragmentSupportingOcean;

    @Inject(at={@At(value="HEAD")}, method={"getVertexSource"}, cancellable=true)
    public void getVertexSource(CallbackInfoReturnable<Optional<String>> info) {
        if (this.vertexSupportingOcean || !Iris.createOceanShader && !Iris.createOceanShadowShader) {
            return;
        }
        String result = ShaderInjection.getVertexSource(this.vertexSource);
        if (result != null) {
            info.setReturnValue(Optional.of(result));
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"getFragmentSource"}, cancellable=true)
    public void getGeometrySource(CallbackInfoReturnable<Optional<String>> info) {
        if (this.geometrySupportingOcean || !Iris.createOceanShader && !Iris.createOceanShadowShader) {
            return;
        }
        String result = ShaderInjection.getGeometrySource(this.geometrySource);
        if (result != null) {
            info.setReturnValue(Optional.of(result));
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"getFragmentSource"}, cancellable=true)
    public void getFragmentSource(CallbackInfoReturnable<Optional<String>> info) {
        if (this.fragmentSupportingOcean || !Iris.createOceanShader && !Iris.createOceanShadowShader) {
            return;
        }
        String result = ShaderInjection.getFragmentSource(this.fragmentSource, Iris.createOceanShadowShader);
        if (result != null) {
            info.setReturnValue(Optional.of(result));
        }
    }

    @Override
    public void setVertexSupportingOcean(boolean vertexSupportingOcean) {
        this.vertexSupportingOcean = vertexSupportingOcean;
    }

    @Override
    public void setGeometrySupportingOcean(boolean geometrySupportingOcean) {
        this.geometrySupportingOcean = geometrySupportingOcean;
    }

    @Override
    public void setFragmentSupportingOcean(boolean fragmentSupportingOcean) {
        this.fragmentSupportingOcean = fragmentSupportingOcean;
    }

    @Override
    public boolean isFragmentSupportingOcean() {
        return this.fragmentSupportingOcean;
    }

    @Override
    public boolean isGeometrySupportingOcean() {
        return this.geometrySupportingOcean;
    }

    @Override
    public boolean isVertexSupportingOcean() {
        return this.vertexSupportingOcean;
    }
}

