/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.mixins.ocean;

import java.util.function.Function;
import net.coderbot.iris.shaderpack.ProgramSet;
import net.coderbot.iris.shaderpack.ProgramSource;
import net.coderbot.iris.shaderpack.ShaderPack;
import net.coderbot.iris.shaderpack.ShaderProperties;
import net.coderbot.iris.shaderpack.include.AbsolutePackPath;
import net.diebuddies.compat.Iris;
import net.diebuddies.physics.ocean.ProgramSetOcean;
import net.diebuddies.physics.ocean.ProgramSourceOcean;
import net.diebuddies.util.ShaderType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ProgramSet.class}, remap=false)
public class MixinProgramSet
implements ProgramSetOcean {
    @Unique
    private ProgramSource oceanSource;
    @Unique
    private ProgramSource shadowSource;

    @Inject(at={@At(value="TAIL")}, method={"<init>"})
    public void constructor(AbsolutePackPath directory, Function<AbsolutePackPath, String> sourceProvider, ShaderProperties shaderProperties, ShaderPack pack, CallbackInfo info) {
        Iris.preprocessStage = ShaderType.VERTEX;
        AbsolutePackPath vertexPath = directory.resolve("gbuffers_water.vsh");
        String vertexSource = sourceProvider.apply(vertexPath);
        Iris.preprocessStage = ShaderType.GEOMETRY;
        AbsolutePackPath geometryPath = directory.resolve("gbuffers_water.gsh");
        String geometrySource = sourceProvider.apply(geometryPath);
        Iris.preprocessStage = ShaderType.FRAGMENT;
        AbsolutePackPath fragmentPath = directory.resolve("gbuffers_water.fsh");
        String fragmentSource = sourceProvider.apply(fragmentPath);
        this.oceanSource = new ProgramSource("gbuffers_ocean", vertexSource, geometrySource, fragmentSource, (ProgramSet)this, shaderProperties, null);
        ProgramSourceOcean addon = (ProgramSourceOcean)this.oceanSource;
        addon.setVertexSupportingOcean(Iris.vertexShaderSupportsOcean);
        addon.setFragmentSupportingOcean(Iris.fragmentShaderSupportsOcean);
        addon.setGeometrySupportingOcean(Iris.geometryShaderSupportsOcean);
        Iris.preprocessStage = ShaderType.VERTEX;
        vertexPath = directory.resolve("shadow.vsh");
        vertexSource = sourceProvider.apply(vertexPath);
        Iris.preprocessStage = ShaderType.GEOMETRY;
        geometryPath = directory.resolve("shadow.gsh");
        geometrySource = sourceProvider.apply(geometryPath);
        Iris.preprocessStage = ShaderType.FRAGMENT;
        fragmentPath = directory.resolve("shadow.fsh");
        fragmentSource = sourceProvider.apply(fragmentPath);
        this.shadowSource = new ProgramSource("gbuffers_ocean_shadow", vertexSource, geometrySource, fragmentSource, (ProgramSet)this, shaderProperties, null);
        addon = (ProgramSourceOcean)this.shadowSource;
        addon.setVertexSupportingOcean(Iris.vertexShaderSupportsOcean);
        addon.setFragmentSupportingOcean(Iris.fragmentShaderSupportsOcean);
        addon.setGeometrySupportingOcean(Iris.geometryShaderSupportsOcean);
        Iris.preprocessStage = null;
    }

    @Override
    public ProgramSource getOceanSource() {
        return this.oceanSource;
    }

    @Override
    public ProgramSource getOceanShadowSource() {
        return this.shadowSource;
    }
}

