/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.mixins.ocean;

import net.diebuddies.config.ConfigClient;
import net.diebuddies.math.Math;
import net.diebuddies.minecraft.weather.WeatherEffects;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.ocean.EntityOcean;
import net.diebuddies.physics.ocean.OceanWorld;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public class MixinEntity
implements EntityOcean {
    @Unique
    private double physicsOffset;
    @Unique
    private double physicsOldOffset;
    @Unique
    private double physicsRoll;
    @Unique
    private double physicsOldRoll;
    @Unique
    private double physicsPitch;
    @Unique
    private double physicsOldPitch;
    @Unique
    private double velocityY;
    @Unique
    private double velocityRoll;
    @Unique
    private double velocityPitch;
    @Unique
    private boolean wasInAir;
    @Unique
    private double rippleTime;
    @Unique
    private boolean wasEyeUnderwater;

    @Inject(at={@At(value="HEAD")}, method={"doWaterSplashEffect"})
    private void physicsmod$doOceanRippleEffect(CallbackInfo info) {
        Entity entity = (Entity)this;
        if (ConfigClient.areOceanPhysicsEnabled() && entity.f_19853_ instanceof ClientLevel) {
            if (ConfigClient.oceanRipples) {
                this.spawnSplashRipple(entity);
            }
            this.spawnSplashParticles(entity);
        }
    }

    @Unique
    private void spawnSplashRipple(Entity entity) {
        Vec3 deltaMovement = entity.m_20184_();
        double vy = java.lang.Math.abs(deltaMovement.f_82480_);
        if (vy < 0.1) {
            return;
        }
        double speed = Math.remapClamp(vy, 0.1, 2.0, 0.0425, 0.0625);
        int amount = (int)Math.remapClamp(vy, 0.1, 2.0, 120.0, 240.0);
        int lifetime = (int)Math.remapClamp(vy, 0.1, 2.0, 70.0, 80.0);
        float scale = (float)Math.remapClamp(vy, 0.1, 2.0, 0.2, 0.65);
        OceanWorld oceanWorld = PhysicsMod.getInstance(entity.f_19853_).getPhysicsWorld().getOceanWorld();
        oceanWorld.spawnRipple(amount, lifetime, scale, entity.m_20185_(), entity.m_20186_() + this.getPhysicsYOffset(), entity.m_20189_(), speed);
    }

    @Unique
    private void spawnSplashParticles(Entity entity) {
        Vec3 deltaMovement = entity.m_20184_();
        double vy = java.lang.Math.abs(deltaMovement.f_82480_);
        if (vy < 0.25) {
            return;
        }
        int splashamount = (int)Math.remapClamp(vy, 0.1, 2.0, 10.0, 75.0);
        double intensity = Math.remapClamp(vy, 0.1, 2.0, 0.075, 0.5);
        float volume = (float)intensity * ConfigClient.oceanSplashVolume;
        float pitch = Math.random() * 0.4f + 0.7f;
        Level level = entity.f_19853_;
        level.m_7785_(entity.m_20185_(), entity.m_20186_() + this.getPhysicsYOffset(), entity.m_20189_(), WeatherEffects.SPLASH_SOUND_EVENT, SoundSource.AMBIENT, volume, pitch, true);
        if (ConfigClient.oceanParticles) {
            OceanWorld.createWaterSplash(level, entity.m_20185_(), entity.m_20186_() + this.getPhysicsYOffset(), entity.m_20189_(), 0.0, 0.0, 0.0, 0.25, intensity, splashamount);
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"tick"})
    private void physicsmod$spawnMovementRippleEffect(CallbackInfo info) {
        Entity entity = (Entity)this;
        if (ConfigClient.areOceanPhysicsEnabled() && entity.f_19853_ instanceof ClientLevel) {
            Vec3 movement;
            double speedSquared;
            if (ConfigClient.oceanRipples && this.isCausingRipples(entity) && (speedSquared = (movement = entity.m_20184_()).m_165925_()) > 0.001) {
                double rippleSpeed = Math.remapClamp(java.lang.Math.sqrt(speedSquared), 0.077, 0.4, 0.0375, 0.0625);
                int lifetime = (int)Math.remapClamp(java.lang.Math.sqrt(speedSquared), 0.077, 0.4, 100.0, 60.0);
                OceanWorld oceanWorld = PhysicsMod.getInstance(entity.f_19853_).getPhysicsWorld().getOceanWorld();
                oceanWorld.spawnAngularRipple(360, lifetime, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), movement.f_82479_, movement.f_82481_, java.lang.Math.toRadians(100.0), rippleSpeed, 0.0);
                double perc = 0.5;
                oceanWorld.spawnAngularRipple(360, lifetime, Mth.m_14139_((double)perc, (double)entity.f_19854_, (double)entity.m_20185_()), Mth.m_14139_((double)perc, (double)entity.f_19855_, (double)entity.m_20186_()), Mth.m_14139_((double)perc, (double)entity.f_19856_, (double)entity.m_20189_()), movement.f_82479_, movement.f_82481_, java.lang.Math.toRadians(100.0), rippleSpeed, 0.0);
            }
            if (this.isCausingSplash(entity)) {
                if (ConfigClient.oceanRipples) {
                    this.spawnSplashRipple(entity);
                }
                this.spawnSplashParticles(entity);
            }
        }
    }

    @Unique
    private boolean isCausingSplash(Entity entity) {
        boolean isEyeUnderwater = entity.m_204029_(FluidTags.f_13131_);
        boolean result = !isEyeUnderwater && this.wasEyeUnderwater;
        this.wasEyeUnderwater = isEyeUnderwater;
        return result;
    }

    @Unique
    private boolean isCausingRipples(Entity entity) {
        boolean isOnSurface = true;
        if (!ConfigClient.oceanStickyEntities && entity instanceof Boat) {
            isOnSurface = !((EntityOcean)entity).isInPhysicsAir();
        }
        return isOnSurface && !entity.m_5833_() && entity.m_20069_() && (entity.f_19853_.m_8055_(entity.m_20183_().m_7494_()).m_60795_() || entity instanceof AbstractClientPlayer && entity.f_19853_.m_8055_(entity.m_20183_().m_7494_().m_7494_()).m_60795_());
    }

    @Inject(at={@At(value="TAIL")}, method={"tick"})
    private void physicsmod$updateOceanTransformations(CallbackInfo info) {
        Entity entity = (Entity)this;
        if (ConfigClient.areOceanPhysicsEnabled() && entity.f_19853_ instanceof ClientLevel) {
            double gravityThreshold;
            OceanWorld oceanWorld = PhysicsMod.getInstance(entity.f_19853_).getPhysicsWorld().getOceanWorld();
            this.physicsOldOffset = this.physicsOffset;
            this.physicsOldRoll = this.physicsRoll;
            this.physicsOldPitch = this.physicsPitch;
            double targetOffset = oceanWorld.computeYOffset(entity.f_19853_, entity);
            boolean inAir = false;
            double threshold = 0.5;
            double absDistance = java.lang.Math.abs(targetOffset - this.physicsOffset);
            double dynamicDamping = 1.0;
            if (absDistance < threshold) {
                dynamicDamping = Math.remap(absDistance / threshold, 0.0, 1.0, 0.0, 1.0);
            }
            if (targetOffset - (gravityThreshold = 0.0) >= this.physicsOffset) {
                this.velocityY += 0.24100000000000002 * dynamicDamping;
                this.velocityY *= 0.6;
            } else if (targetOffset + gravityThreshold < this.physicsOffset) {
                this.velocityY += -0.040999999999999995 * dynamicDamping;
                this.velocityY *= 0.95;
            } else {
                this.velocityY *= 0.8;
            }
            if (this.physicsOffset - targetOffset > 0.075) {
                inAir = true;
            }
            this.physicsOffset += this.velocityY;
            if (ConfigClient.oceanStickyEntities) {
                this.physicsOffset = targetOffset;
            }
            if (entity instanceof Boat) {
                double wx = entity.m_20185_();
                double wy = entity.m_20186_();
                double wz = entity.m_20189_();
                Vec3 forward = entity.m_20252_(1.0f);
                double leftX = forward.f_82481_;
                double leftZ = -forward.f_82479_;
                double leftHeight = oceanWorld.calculateYOffset(wx + leftX, wy, wz + leftZ);
                double rightHeight = oceanWorld.calculateYOffset(wx - leftX, wy, wz - leftZ);
                double forwardHeight = oceanWorld.calculateYOffset(wx + forward.f_82479_, wy, wz + forward.f_82481_);
                double backwardsHeight = oceanWorld.calculateYOffset(wx - forward.f_82479_, wy, wz - forward.f_82481_);
                double targetRoll = java.lang.Math.atan2(rightHeight - leftHeight, 2.0);
                double targetPitch = java.lang.Math.atan2(backwardsHeight - forwardHeight, 2.0);
                double dampingAdjusterRoll = 1.0 - java.lang.Math.pow(java.lang.Math.min(1.0, java.lang.Math.abs(this.physicsRoll) / java.lang.Math.toRadians(130.0)), 3.0);
                double dampingAdjusterPitch = 1.0 - java.lang.Math.pow(java.lang.Math.min(1.0, java.lang.Math.abs(this.physicsPitch) / java.lang.Math.toRadians(130.0)), 3.0);
                if (inAir) {
                    this.velocityRoll *= 0.95 * dampingAdjusterRoll;
                    this.velocityPitch *= 0.95 * dampingAdjusterPitch;
                } else {
                    this.velocityRoll += (targetRoll - this.physicsOldRoll) * 0.2;
                    this.velocityPitch += (targetPitch - this.physicsOldPitch) * 0.2;
                    this.velocityRoll *= 0.6 * dampingAdjusterRoll;
                    this.velocityPitch *= 0.6 * dampingAdjusterPitch;
                }
                this.physicsRoll += this.velocityRoll;
                this.physicsPitch += this.velocityPitch;
                if (this.wasInAir != inAir && this.velocityY < -0.11 && !ConfigClient.oceanStickyEntities) {
                    Vec3 movement = entity.m_20184_();
                    int amount = (int)Math.remapClamp(this.velocityY, -0.11, -0.25, 75.0, 150.0);
                    double intensity = Math.remapClamp(this.velocityY, -0.11, -0.25, 0.5, 1.0);
                    float volume = (float)intensity * 0.8f * ConfigClient.oceanSplashVolume;
                    float pitch = Math.random() * 0.3f + 0.8f;
                    entity.f_19853_.m_7785_(wx, wy + this.physicsOffset, wz, WeatherEffects.SPLASH_SOUND_EVENT, SoundSource.AMBIENT, volume, pitch, true);
                    if (ConfigClient.oceanParticles) {
                        OceanWorld.createWaterSplash(entity.f_19853_, entity.m_20185_(), entity.m_20186_() + targetOffset, entity.m_20189_(), movement.f_82479_ * 0.4, 0.0, movement.f_82481_ * 0.4, 1.0, intensity, amount);
                    }
                }
                if (ConfigClient.oceanStickyEntities) {
                    this.physicsRoll = targetRoll;
                    this.physicsPitch = targetPitch;
                }
            }
            this.wasInAir = ConfigClient.oceanStickyEntities ? false : inAir;
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"getBoundingBoxForCulling"}, cancellable=true)
    private void physicsmod$modifyBoundingBoxForCulling(CallbackInfoReturnable<AABB> info) {
        AABB aabb = (AABB)info.getReturnValue();
        if (aabb != null) {
            info.setReturnValue((Object)aabb.m_82386_(0.0, this.physicsOffset, 0.0));
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"pick"}, cancellable=true)
    private void physicsmod$modifyBlockPickingForOceanTransformations(double range, float renderPercent, boolean bl, CallbackInfoReturnable<HitResult> info) {
        Entity entity = (Entity)this;
        if (ConfigClient.areOceanPhysicsEnabled() && entity.f_19853_ instanceof ClientLevel && ConfigClient.oceanAdjustHitbox) {
            OceanWorld oceanWorld = PhysicsMod.getInstance(entity.f_19853_).getPhysicsWorld().getOceanWorld();
            double yOffset = oceanWorld.computeYOffset(entity.f_19853_, entity, renderPercent);
            Vec3 oldEyePos = entity.m_20299_(renderPercent);
            Vec3 eyePos = new Vec3(oldEyePos.f_82479_, oldEyePos.f_82480_ + yOffset, oldEyePos.f_82481_);
            Vec3 viewDir = entity.m_20252_(renderPercent);
            Vec3 target = eyePos.m_82520_(viewDir.f_82479_ * range, viewDir.f_82480_ * range, viewDir.f_82481_ * range);
            info.setReturnValue((Object)entity.f_19853_.m_45547_(new ClipContext(eyePos, target, ClipContext.Block.OUTLINE, bl ? ClipContext.Fluid.ANY : ClipContext.Fluid.NONE, entity)));
        }
    }

    @Override
    public double getPhysicsYOffset(float renderPercent) {
        if (PhysicsMod.hudRendering) {
            return 0.0;
        }
        return Mth.m_14139_((double)renderPercent, (double)this.getPhysicsOldYOffset(), (double)this.getPhysicsYOffset());
    }

    @Override
    public double getPhysicsPitch(float renderPercent) {
        if (PhysicsMod.hudRendering) {
            return 0.0;
        }
        return Mth.m_14139_((double)renderPercent, (double)this.getPhysicsOldPitch(), (double)this.getPhysicsPitch());
    }

    @Override
    public double getPhysicsRoll(float renderPercent) {
        if (PhysicsMod.hudRendering) {
            return 0.0;
        }
        return Mth.m_14139_((double)renderPercent, (double)this.getPhysicsOldRoll(), (double)this.getPhysicsRoll());
    }

    @Override
    public double getPhysicsYOffset() {
        Entity entity = (Entity)this;
        EntityOcean vehicle = (EntityOcean)entity.m_20202_();
        if (vehicle != null) {
            return vehicle.getPhysicsYOffset();
        }
        return this.physicsOffset;
    }

    @Override
    public double getPhysicsOldYOffset() {
        Entity entity = (Entity)this;
        EntityOcean vehicle = (EntityOcean)entity.m_20202_();
        if (vehicle != null) {
            return vehicle.getPhysicsOldYOffset();
        }
        return this.physicsOldOffset;
    }

    @Override
    public double getPhysicsPitch() {
        Entity entity = (Entity)this;
        EntityOcean vehicle = (EntityOcean)entity.m_20202_();
        if (vehicle != null) {
            return vehicle.getPhysicsPitch();
        }
        return this.physicsPitch;
    }

    @Override
    public double getPhysicsOldPitch() {
        Entity entity = (Entity)this;
        EntityOcean vehicle = (EntityOcean)entity.m_20202_();
        if (vehicle != null) {
            return vehicle.getPhysicsOldPitch();
        }
        return this.physicsOldPitch;
    }

    @Override
    public double getPhysicsRoll() {
        Entity entity = (Entity)this;
        EntityOcean vehicle = (EntityOcean)entity.m_20202_();
        if (vehicle != null) {
            return vehicle.getPhysicsRoll();
        }
        return this.physicsRoll;
    }

    @Override
    public double getPhysicsOldRoll() {
        Entity entity = (Entity)this;
        EntityOcean vehicle = (EntityOcean)entity.m_20202_();
        if (vehicle != null) {
            return vehicle.getPhysicsOldRoll();
        }
        return this.physicsOldRoll;
    }

    @Override
    public boolean isInPhysicsAir() {
        return this.wasInAir;
    }
}

