/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.mixins;

import java.util.Map;
import net.diebuddies.config.ConfigBlocks;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.math.Math;
import net.diebuddies.physics.IRigidBody;
import net.diebuddies.physics.Model;
import net.diebuddies.physics.PhysicsEntity;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.settings.animation.ParticleEngineExtension;
import net.diebuddies.physics.settings.blocks.BlockPhysicsType;
import net.diebuddies.physics.settings.blocks.BlockSetting;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.joml.Matrix4dc;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector4f;
import org.lwjgl.system.MemoryStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import physx.common.PxVec3;
import physx.physics.PxRigidBody;

@Mixin(value={ParticleEngine.class})
public class MixinParticleEngine
implements ParticleEngineExtension {
    @Shadow
    @Final
    private Map<ResourceLocation, ParticleProvider<?>> f_107293_;
    @Shadow
    protected ClientLevel f_107287_;
    @Shadow
    @Final
    private RandomSource f_107292_;

    @Inject(at={@At(value="HEAD")}, method={"destroy"}, cancellable=true)
    public void destroyParticles(BlockPos pos, BlockState state, CallbackInfo info) {
        BlockSetting blockSetting = ConfigBlocks.getBlockSetting(state.m_60734_());
        if (blockSetting.getType() == BlockPhysicsType.PARTICLES && !state.m_60795_()) {
            info.cancel();
        } else if (!ConfigClient.minecraftBlockBreakParticles) {
            info.cancel();
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"crack"}, cancellable=true)
    public void crack(BlockPos blockPos, Direction direction, CallbackInfo info) {
        BlockState blockState = this.f_107287_.m_8055_(blockPos);
        if (ConfigClient.crackPhysicsParticles && blockState.m_60799_() != RenderShape.INVISIBLE) {
            Camera camera = Minecraft.m_91087_().f_91063_.m_109153_();
            int blockX = blockPos.m_123341_();
            int blockY = blockPos.m_123342_();
            int blockZ = blockPos.m_123343_();
            if (camera.m_90593_() && camera.m_90583_().m_82531_((double)blockX, (double)blockY, (double)blockZ) < ConfigClient.blockPhysicsRange * ConfigClient.blockPhysicsRange) {
                IRigidBody body;
                float offset = 0.1f;
                AABB aabb = blockState.m_60808_((BlockGetter)this.f_107287_, blockPos).m_83215_();
                double posX = (double)blockX + this.f_107292_.m_188500_() * (aabb.f_82291_ - aabb.f_82288_ - (double)(offset * 2.0f)) + (double)offset + aabb.f_82288_;
                double posY = (double)blockY + this.f_107292_.m_188500_() * (aabb.f_82292_ - aabb.f_82289_ - (double)(offset * 2.0f)) + (double)offset + aabb.f_82289_;
                double posZ = (double)blockZ + this.f_107292_.m_188500_() * (aabb.f_82293_ - aabb.f_82290_ - (double)(offset * 2.0f)) + (double)offset + aabb.f_82290_;
                if (direction == Direction.DOWN) {
                    posY = (double)blockY + aabb.f_82289_ - (double)offset;
                }
                if (direction == Direction.UP) {
                    posY = (double)blockY + aabb.f_82292_ + (double)offset;
                }
                if (direction == Direction.NORTH) {
                    posZ = (double)blockZ + aabb.f_82290_ - (double)offset;
                }
                if (direction == Direction.SOUTH) {
                    posZ = (double)blockZ + aabb.f_82293_ + (double)offset;
                }
                if (direction == Direction.WEST) {
                    posX = (double)blockX + aabb.f_82288_ - (double)offset;
                }
                if (direction == Direction.EAST) {
                    posX = (double)blockX + aabb.f_82291_ + (double)offset;
                }
                Vec3i normal = direction.m_122436_();
                TextureAtlasSprite sprite = Minecraft.m_91087_().m_91289_().m_110907_().m_110882_(blockState);
                PhysicsMod mod = PhysicsMod.getInstance((Level)this.f_107287_);
                PhysicsEntity entity = new PhysicsEntity(PhysicsEntity.Type.PARTICLE, null);
                entity.getTransformation().translation(posX, posY, posZ);
                entity.getOldTransformation().set((Matrix4dc)entity.getTransformation());
                Model model = entity.models.get(0);
                model.texture = sprite;
                model.textureID = Minecraft.m_91087_().m_91097_().m_118506_(sprite.m_247685_()).m_117963_();
                entity.scale = Math.random() * 0.06f + 0.04f;
                entity.backfaceCulling = true;
                model.mesh = PhysicsMod.brokenBlock.get(0);
                int color = Minecraft.m_91087_().m_91298_().m_92577_(blockState, (BlockAndTintGetter)this.f_107287_, blockPos, 0);
                if (color == -1) {
                    color = -1;
                }
                entity.setColor(color);
                if (blockState.m_60734_() == Blocks.f_50256_ || blockState.m_60734_() == Blocks.f_50440_) {
                    entity.setColor(-1);
                }
                if ((body = mod.physicsWorld.addBlockParticle(entity)).getRigidBody() instanceof PxRigidBody) {
                    PxRigidBody rigidBody = (PxRigidBody)body.getRigidBody();
                    float strength = 2.0f;
                    Vector3f speed = new Vector3f((float)normal.m_123341_() * 0.3f, (float)normal.m_123342_() * 0.3f, (float)normal.m_123343_() * 0.3f);
                    speed.x += (Math.random() - 0.5f) * 0.3f;
                    speed.y += (Math.random() - 0.5f) * 0.3f;
                    speed.z += (Math.random() - 0.5f) * 0.3f;
                    speed.normalize();
                    try (MemoryStack mem = MemoryStack.stackPush();){
                        PxVec3 velocity = PxVec3.createAt(mem, MemoryStack::nmalloc, speed.x * strength, speed.y * strength, speed.z * strength);
                        rigidBody.setLinearVelocity(velocity);
                    }
                }
                float uo = Math.random() * 3.0f;
                float vo = Math.random() * 3.0f;
                model.customUVs = new Vector4f(sprite.m_118367_((double)(uo / 4.0f * 16.0f)), sprite.m_118367_((double)((uo + 1.0f) / 4.0f * 16.0f)), sprite.m_118393_((double)(vo / 4.0f * 16.0f)), sprite.m_118393_((double)((vo + 1.0f) / 4.0f * 16.0f)));
                float xScale = model.customUVs.y - model.customUVs.x;
                float yScale = model.customUVs.w - model.customUVs.z;
                model.textureMatrix = new Matrix4f().translate(model.customUVs.x, model.customUVs.z, 0.0f).scale(xScale, yScale, 0.0f);
                info.cancel();
            }
        }
    }

    @Override
    public Map<ResourceLocation, ParticleProvider<?>> getParticleProviders() {
        return this.f_107293_;
    }
}

