/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.mixins;

import com.mojang.blaze3d.systems.RenderSystem;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.physics.BlockUpdate;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.ocean.BlockToByte;
import net.diebuddies.physics.ocean.OceanBlockUpdate;
import net.diebuddies.physics.snow.SnowSearcher;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LevelChunk.class})
public class MixinLevelChunk {
    @Shadow
    private Level f_62776_;

    @Inject(at={@At(value="HEAD")}, method={"setBlockState"})
    private void setBlockState(BlockPos pos, BlockState state, boolean isMoving, CallbackInfoReturnable<BlockState> ci) {
        if (isMoving) {
            return;
        }
        if (RenderSystem.m_69586_() && this.f_62776_ instanceof ClientLevel) {
            BlockState before = this.f_62776_.m_8055_(pos);
            PhysicsMod mod = PhysicsMod.getInstance(this.f_62776_);
            mod.blockUpdates.add(pos.m_7949_());
            if (before != null && state != null && (before.m_60795_() && !state.m_60795_() || state.m_60795_() && !before.m_60795_() || !before.m_60795_() && state.m_60734_() == Blocks.f_49990_)) {
                BlockUpdate update = new BlockUpdate(this.f_62776_, pos.m_7949_(), before);
                if (before.m_155947_()) {
                    update.blockEntity = this.f_62776_.m_7702_(pos);
                }
                mod.updateQueue.add(update);
            }
            if (ConfigClient.areSnowPhysicsEnabled() && before != null && state != null && (SnowSearcher.getSnowProperty(state) != null || SnowSearcher.getSnowProperty(before) != null)) {
                mod.physicsWorld.getSnowWorld().blockUpdates.add(new BlockUpdate(this.f_62776_, pos.m_7949_(), state));
            }
            if (ConfigClient.areOceanPhysicsEnabled() && before != null && state != null) {
                mod.physicsWorld.getOceanWorld().getBlockUpdates().add(new OceanBlockUpdate(this.f_62776_, pos.m_7949_(), BlockToByte.convert(state)));
            }
        }
    }
}

