/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.minecraft.weather;

import net.diebuddies.math.Math;
import net.diebuddies.minecraft.weather.FastTextureSheetParticle;
import net.diebuddies.minecraft.weather.WeatherEffects;
import net.diebuddies.physics.snow.math.AABB3D;
import net.diebuddies.physics.vines.VineHelper;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Quaternionf;
import org.joml.Vector3d;

public abstract class WeatherParticle
extends FastTextureSheetParticle {
    protected Quaternionf tmpRotation = new Quaternionf();
    protected BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
    protected BlockPos.MutableBlockPos lastPos = new BlockPos.MutableBlockPos(0, 1, 0);
    protected int cachedBrightness;
    protected double dampingX = 0.98;
    protected double dampingY = 0.98;
    protected double dampingZ = 0.98;
    protected int r;
    protected int g;
    protected int b;
    protected int a;
    protected int argb;
    protected AABB3D aabb;

    public WeatherParticle(ClientLevel clientLevel, double x, double y, double z, double vx, double vy, double vz) {
        super(clientLevel, x, y, z);
        this.f_107226_ = 0.06f;
        this.f_107215_ = vx;
        this.f_107216_ = vy;
        this.f_107217_ = vz;
        this.quadSize = 0.14f;
        this.f_107225_ = Math.randomInt(200) + 200;
        this.aabb = new AABB3D(x - 0.01, y - 0.01, z - 0.01, x + 0.01, y + 0.01, z + 0.01);
        this.move();
        this.calculateLight();
    }

    private void move() {
        Vector3d start = this.aabb.start;
        Vector3d end = this.aabb.end;
        start.x += this.f_107215_;
        start.y += this.f_107216_;
        start.z += this.f_107217_;
        end.x += this.f_107215_;
        end.y += this.f_107216_;
        end.z += this.f_107217_;
        this.f_107212_ += this.f_107215_;
        this.f_107213_ += this.f_107216_;
        this.f_107214_ += this.f_107217_;
    }

    public void setColor(int r, int g, int b, int a) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
        this.argb = (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107430_;
    }

    public int m_6355_(float renderPercent) {
        return this.cachedBrightness;
    }

    private void calculateLight() {
        this.blockPos.m_122169_(this.f_107209_, this.f_107210_, this.f_107211_);
        if (WeatherEffects.invalidateLight || (this.blockPos.m_123341_() != this.lastPos.m_123341_() || this.blockPos.m_123342_() != this.lastPos.m_123342_() || this.blockPos.m_123343_() != this.lastPos.m_123343_()) && this.f_107208_.m_46805_((BlockPos)this.blockPos)) {
            this.lastPos.m_122190_((Vec3i)this.blockPos);
            this.cachedBrightness = LevelRenderer.m_109541_((BlockAndTintGetter)this.f_107208_, (BlockPos)this.blockPos);
        }
    }

    public void m_5989_() {
        ++WeatherEffects.aliveParticles;
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
            return;
        }
        if (this.f_107220_) {
            return;
        }
        this.calculateLight();
        this.f_107216_ -= (double)this.f_107226_;
        this.move();
        Camera camera = Minecraft.m_91087_().f_91063_.m_109153_();
        Vec3 cameraPos = camera.m_90583_();
        float currentX = (float)(this.f_107212_ - cameraPos.m_7096_());
        float currentY = (float)(this.f_107213_ - cameraPos.m_7098_());
        float currentZ = (float)(this.f_107214_ - cameraPos.m_7094_());
        if ((double)(currentX * currentX + currentY * currentY + currentZ * currentZ) > 196.0) {
            this.m_107274_();
            return;
        }
        this.blockPos.m_122169_(this.f_107212_, this.f_107213_, this.f_107214_);
        BlockState state = this.f_107208_.m_8055_((BlockPos)this.blockPos);
        VoxelShape voxelShape = state.m_60812_((BlockGetter)this.f_107208_, (BlockPos)this.blockPos);
        if (!voxelShape.m_83281_() && VineHelper.getSetting(state) == null) {
            for (AABB aabb : voxelShape.m_83299_()) {
                if (!this.aabb.intersect(aabb.f_82288_ + (double)this.blockPos.m_123341_(), aabb.f_82289_ + (double)this.blockPos.m_123342_(), aabb.f_82290_ + (double)this.blockPos.m_123343_(), aabb.f_82291_ + (double)this.blockPos.m_123341_(), aabb.f_82292_ + (double)this.blockPos.m_123342_(), aabb.f_82293_ + (double)this.blockPos.m_123343_())) continue;
                this.m_107274_();
                return;
            }
        }
        this.f_107215_ *= this.dampingX;
        this.f_107216_ *= this.dampingY;
        this.f_107217_ *= this.dampingZ;
        FluidState fluidState = this.f_107208_.m_6425_((BlockPos)this.blockPos);
        if (fluidState.m_76152_() == Fluids.f_76193_ && this.f_107213_ < (double)((float)this.blockPos.m_123342_() + fluidState.m_76155_((BlockGetter)this.f_107208_, (BlockPos)this.blockPos))) {
            this.m_107274_();
        }
    }
}

