/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.minecraft.weather;

import com.mojang.blaze3d.vertex.VertexConsumer;
import net.diebuddies.compat.Sodium;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.math.Math;
import net.diebuddies.minecraft.weather.WeatherParticle;
import net.diebuddies.physics.StarterClient;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class SnowParticle
extends WeatherParticle {
    private static Vector3f position0 = new Vector3f(-1.0f, -1.0f, 0.0f);
    private static Vector3f position1 = new Vector3f(-1.0f, 1.0f, 0.0f);
    private static Vector3f position2 = new Vector3f(1.0f, 1.0f, 0.0f);
    private static Vector3f position3 = new Vector3f(1.0f, -1.0f, 0.0f);
    private static Vector3f tmp0 = new Vector3f();
    private static Vector3f tmp1 = new Vector3f();
    private static Vector3f tmp2 = new Vector3f();
    private static Vector3f tmp3 = new Vector3f();
    private static float oldRotX;
    private static float oldRotY;
    private static float oldRotZ;
    private static float oldRotW;

    public SnowParticle(ClientLevel clientLevel, double x, double y, double z, double vx, double vy, double vz) {
        super(clientLevel, x, y, z, vx, vy, vz);
        this.f_107226_ = 0.002f;
        this.dampingX = 0.999;
        this.dampingY = 0.98;
        this.dampingZ = 0.999;
        this.setColor(255, 255, 255, (int)((float)(155 + (int)((double)Math.random() * 40.0)) * ConfigClient.particleSnowOpacity));
    }

    public void m_5744_(VertexConsumer vertexConsumer, Camera camera, float renderPercent) {
        Vec3 cameraPos = camera.m_90583_();
        double px = org.joml.Math.lerp((double)this.f_107209_, (double)this.f_107212_, (double)renderPercent);
        double py = org.joml.Math.lerp((double)this.f_107210_, (double)this.f_107213_, (double)renderPercent);
        double pz = org.joml.Math.lerp((double)this.f_107211_, (double)this.f_107214_, (double)renderPercent);
        float currentX = (float)(px - cameraPos.m_7096_());
        float currentY = (float)(py - cameraPos.m_7098_());
        float currentZ = (float)(pz - cameraPos.m_7094_());
        Quaternionf cameraRotation = camera.m_253121_();
        if (oldRotX != cameraRotation.x() || oldRotY != cameraRotation.y() || oldRotZ != cameraRotation.z() || oldRotW != cameraRotation.w()) {
            float quadSize = this.getQuadSize();
            this.tmpRotation.set(cameraRotation.x(), cameraRotation.y(), cameraRotation.z(), cameraRotation.w());
            this.tmpRotation.transform(tmp0.set((Vector3fc)position0)).mul(quadSize);
            this.tmpRotation.transform(tmp1.set((Vector3fc)position1)).mul(quadSize);
            this.tmpRotation.transform(tmp2.set((Vector3fc)position2)).mul(quadSize);
            this.tmpRotation.transform(tmp3.set((Vector3fc)position3)).mul(quadSize);
            oldRotX = cameraRotation.x();
            oldRotY = cameraRotation.y();
            oldRotZ = cameraRotation.z();
            oldRotW = cameraRotation.w();
        }
        float u0 = this.getU0();
        float u1 = this.getU1();
        float v0 = this.getV0();
        float v1 = this.getV1();
        int light = this.m_6355_(renderPercent);
        if (StarterClient.sodium) {
            Sodium.renderParticle(vertexConsumer, tmp0, tmp1, tmp2, tmp3, currentX, currentY, currentZ, u0, v0, u1, v1, this.argb, light);
        } else {
            vertexConsumer.m_5483_((double)(tmp0.x() + currentX), (double)(tmp0.y() + currentY), (double)(tmp0.z() + currentZ)).m_7421_(u1, v1).m_6122_(this.r, this.g, this.b, this.a).m_85969_(light).m_5752_();
            vertexConsumer.m_5483_((double)(tmp1.x() + currentX), (double)(tmp1.y() + currentY), (double)(tmp1.z() + currentZ)).m_7421_(u1, v0).m_6122_(this.r, this.g, this.b, this.a).m_85969_(light).m_5752_();
            vertexConsumer.m_5483_((double)(tmp2.x() + currentX), (double)(tmp2.y() + currentY), (double)(tmp2.z() + currentZ)).m_7421_(u0, v0).m_6122_(this.r, this.g, this.b, this.a).m_85969_(light).m_5752_();
            vertexConsumer.m_5483_((double)(tmp3.x() + currentX), (double)(tmp3.y() + currentY), (double)(tmp3.z() + currentZ)).m_7421_(u0, v1).m_6122_(this.r, this.g, this.b, this.a).m_85969_(light).m_5752_();
        }
    }

    @Override
    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public Provider(SpriteSet spriteSet) {
            this.sprite = spriteSet;
        }

        public Particle createParticle(SimpleParticleType simpleParticleType, ClientLevel clientLevel, double x, double y, double z, double vx, double vy, double vz) {
            SnowParticle particle = new SnowParticle(clientLevel, x, y, z, vx, vy, vz);
            particle.pickSprite(this.sprite);
            return particle;
        }
    }
}

