/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.compat;

import com.mojang.blaze3d.vertex.VertexConsumer;
import me.jellysquid.mods.sodium.client.render.RenderGlobal;
import me.jellysquid.mods.sodium.client.render.texture.SpriteUtil;
import me.jellysquid.mods.sodium.client.render.vertex.VertexBufferWriter;
import me.jellysquid.mods.sodium.client.render.vertex.formats.ParticleVertex;
import me.jellysquid.mods.sodium.client.world.WorldRendererExtended;
import net.diebuddies.compat.BlockEntityVertexConsumerSodium;
import net.diebuddies.compat.BoundingBoxGetterSodium;
import net.diebuddies.compat.DummyVertexConsumerSodium;
import net.diebuddies.physics.BlockEntityVertexConsumer;
import net.diebuddies.physics.DummyVertexConsumer;
import net.diebuddies.physics.StarterClient;
import net.diebuddies.physics.settings.mobs.BoundingBoxGetter;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import org.joml.Vector3f;
import org.lwjgl.system.MemoryStack;

public class Sodium {
    public static void markSpriteActive(TextureAtlasSprite sprite) {
        if (StarterClient.sodium) {
            try {
                SpriteUtil.markSpriteActive((TextureAtlasSprite)sprite);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void scheduleChunkRebuild(LevelRenderer renderer, int x, int y, int z, boolean important) {
        if (StarterClient.sodium) {
            try {
                ((WorldRendererExtended)renderer).getSodiumWorldRenderer().scheduleRebuildForChunk(x, y, z, important);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static BlockEntityVertexConsumer getNewBlockConsumer() {
        return new BlockEntityVertexConsumerSodium();
    }

    public static DummyVertexConsumer getNewDummyConsumer() {
        return new DummyVertexConsumerSodium();
    }

    public static BoundingBoxGetter getNewBoundingBoxConsumer() {
        return new BoundingBoxGetterSodium();
    }

    public static void renderParticle(VertexConsumer vertexConsumer, Vector3f tmp0, Vector3f tmp1, Vector3f tmp2, Vector3f tmp3, float currentX, float currentY, float currentZ, float u0, float v0, float u1, float v1, int color, int light) {
        VertexBufferWriter writer = VertexBufferWriter.of((VertexConsumer)vertexConsumer);
        try (MemoryStack stack = RenderGlobal.VERTEX_DATA.push();){
            long buffer;
            long ptr = buffer = stack.nmalloc(112);
            ParticleVertex.write((long)ptr, (float)(tmp0.x + currentX), (float)(tmp0.y + currentY), (float)(tmp0.z + currentZ), (int)color, (float)u1, (float)v1, (int)light);
            ParticleVertex.write((long)(ptr += 28L), (float)(tmp1.x + currentX), (float)(tmp1.y + currentY), (float)(tmp1.z + currentZ), (int)color, (float)u1, (float)v0, (int)light);
            ParticleVertex.write((long)(ptr += 28L), (float)(tmp2.x + currentX), (float)(tmp2.y + currentY), (float)(tmp2.z + currentZ), (int)color, (float)u0, (float)v0, (int)light);
            ParticleVertex.write((long)(ptr += 28L), (float)(tmp3.x + currentX), (float)(tmp3.y + currentY), (float)(tmp3.z + currentZ), (int)color, (float)u0, (float)v1, (int)light);
            ptr += 28L;
            writer.push(stack, buffer, 4, ParticleVertex.FORMAT);
        }
    }
}

