/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.mixin.client;

import com.alrex.parcool.client.animation.PlayerModelTransformer;
import com.alrex.parcool.common.attachment.client.Animation;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.entity.state.PlayerRenderState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PlayerModel.class})
public abstract class PlayerModelMixin
extends HumanoidModel<PlayerRenderState> {
    @Shadow
    @Final
    private boolean slim;
    @Unique
    private PlayerModelTransformer parCool$transformer = null;

    public PlayerModelMixin(ModelPart p_i1148_1_) {
        super(p_i1148_1_);
    }

    @Inject(method={"setupAnim(Lnet/minecraft/client/renderer/entity/state/PlayerRenderState;)V"}, at={@At(value="HEAD")}, cancellable=true)
    protected void onSetupAnimHead(PlayerRenderState renderState, CallbackInfo info) {
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null) {
            return;
        }
        Entity entity = level.getEntity(renderState.id);
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        PlayerModel model = (PlayerModel)this;
        this.parCool$transformer = new PlayerModelTransformer(player, model, this.slim, renderState, renderState.rightArmPose, renderState.leftArmPose);
        this.parCool$transformer.reset();
        Animation animation = Animation.get(player);
        if (animation == null) {
            return;
        }
        boolean shouldCancel = animation.animatePre(player, this.parCool$transformer);
        if (shouldCancel) {
            this.parCool$transformer = null;
            info.cancel();
        }
    }

    @Inject(method={"setupAnim(Lnet/minecraft/client/renderer/entity/state/PlayerRenderState;)V"}, at={@At(value="TAIL")})
    protected void onSetupAnimTail(PlayerRenderState renderState, CallbackInfo ci) {
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null) {
            return;
        }
        Entity entity = level.getEntity(renderState.id);
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        Animation animation = Animation.get(player);
        if (this.parCool$transformer != null) {
            animation.animatePost(player, this.parCool$transformer);
            this.parCool$transformer = null;
        }
    }
}

