/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.mixin.client;

import com.alrex.parcool.common.attachment.common.Parkourability;
import com.mojang.authlib.GameProfile;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LocalPlayer.class})
public abstract class LocalPlayerMixin
extends AbstractClientPlayer {
    private boolean oldSprinting = false;

    public LocalPlayerMixin(ClientLevel p_250460_, GameProfile p_249912_) {
        super(p_250460_, p_249912_);
    }

    @Inject(method={"isShiftKeyDown"}, at={@At(value="HEAD")}, cancellable=true)
    public void onIsShiftKeyDown(CallbackInfoReturnable<Boolean> cir) {
        Parkourability parkourability = Parkourability.get((Player)this);
        if (parkourability == null) {
            return;
        }
        if (parkourability.getBehaviorEnforcer().cancelSneak()) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"aiStep"}, at={@At(value="HEAD")})
    public void onAiStep(CallbackInfo ci) {
        LocalPlayer player = (LocalPlayer)this;
        if (player.isLocalPlayer()) {
            boolean flag1;
            boolean flag = !player.input.hasForwardImpulse() || !((float)player.getFoodData().getFoodLevel() > 6.0f) && !this.getAbilities().mayfly;
            boolean bl = flag1 = flag || this.isInWater() && !this.isUnderWater();
            if (this.oldSprinting && !flag1) {
                player.setSprinting(true);
            }
            this.oldSprinting = player.isSprinting();
        }
    }

    @Inject(method={"move"}, at={@At(value="HEAD")}, cancellable=true)
    public void onMove(MoverType type, Vec3 pos, CallbackInfo ci) {
        LocalPlayer player = (LocalPlayer)this;
        Parkourability parkourability = Parkourability.get((Player)player);
        if (parkourability == null) {
            return;
        }
        if (type != MoverType.SELF) {
            return;
        }
        Vec3 enforcedMovePos = parkourability.getBehaviorEnforcer().getEnforcedMovePoint();
        if (enforcedMovePos != null) {
            ci.cancel();
            Vec3 dMove = enforcedMovePos.subtract(player.position());
            player.setDeltaMovement(dMove);
            super.move(type, dMove);
        }
    }
}

