/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.network.payload;

import com.alrex.parcool.common.attachment.Attachments;
import com.alrex.parcool.common.attachment.common.ReadonlyStamina;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record StaminaPayload(UUID playerID, ReadonlyStamina stamina) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<StaminaPayload> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"parcool", (String)"payload.stamina"));
    public static final StreamCodec<ByteBuf, StaminaPayload> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_LONG, s -> s.playerID().getMostSignificantBits(), (StreamCodec)ByteBufCodecs.VAR_LONG, s -> s.playerID().getLeastSignificantBits(), ReadonlyStamina.STREAM_CODEC, StaminaPayload::stamina, (ms, ls, s) -> new StaminaPayload(new UUID((long)ms, (long)ls), (ReadonlyStamina)s));

    @Nonnull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handleClient(StaminaPayload payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player().level().getPlayerByUUID(payload.playerID);
            if (player == null || player.isLocalPlayer()) {
                return;
            }
            player.setData(Attachments.STAMINA, (Object)payload.stamina);
        });
    }

    public static void handleServer(StaminaPayload payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player().level().getPlayerByUUID(payload.playerID);
            if (player == null) {
                return;
            }
            PacketDistributor.sendToAllPlayers((CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
            player.setData(Attachments.STAMINA, (Object)payload.stamina);
        });
    }
}

