/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.client.hud.impl;

import com.alrex.parcool.client.hud.Position;
import com.alrex.parcool.common.action.Action;
import com.alrex.parcool.common.attachment.common.Parkourability;
import com.alrex.parcool.common.attachment.common.ReadonlyStamina;
import com.alrex.parcool.config.ParCoolConfig;
import com.alrex.parcool.utilities.MathUtil;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.event.ClientTickEvent;

@OnlyIn(value=Dist.CLIENT)
public class StaminaHUD {
    public static final ResourceLocation STAMINA_CHARGING = ResourceLocation.fromNamespaceAndPath((String)"parcool", (String)"hud/large_stamina/stamina_bar_charging");
    public static final ResourceLocation STAMINA_DEPLETED = ResourceLocation.fromNamespaceAndPath((String)"parcool", (String)"hud/large_stamina/stamina_bar_depleted");
    public static final ResourceLocation STAMINA_EMPTY_CHARGE = ResourceLocation.fromNamespaceAndPath((String)"parcool", (String)"hud/large_stamina/stamina_bar_empty");
    public static final ResourceLocation STAMINA_EMPTY = ResourceLocation.fromNamespaceAndPath((String)"parcool", (String)"hud/large_stamina/stamina_bar_empty_no_charge");
    public static final ResourceLocation[] STAMINA_FULL = new ResourceLocation[]{ResourceLocation.fromNamespaceAndPath((String)"parcool", (String)"hud/large_stamina/stamina_bar_full_1"), ResourceLocation.fromNamespaceAndPath((String)"parcool", (String)"hud/large_stamina/stamina_bar_full_2"), ResourceLocation.fromNamespaceAndPath((String)"parcool", (String)"hud/large_stamina/stamina_bar_full_3")};
    private float shadowScale = 1.0f;
    private int renderGageType = 0;
    private int renderGageTick = 0;
    private float statusValue = 0.0f;
    private float oldStatusValue = 0.0f;
    private boolean showStatus = false;

    public void onTick(ClientTickEvent.Post event, LocalPlayer player) {
        Parkourability parkourability = Parkourability.get((Player)player);
        if (++this.renderGageTick >= 5) {
            this.renderGageTick = 0;
            if (++this.renderGageType > 2) {
                this.renderGageType = 0;
            }
        }
        this.oldStatusValue = this.statusValue;
        boolean oldShowStatus = this.showStatus;
        this.showStatus = false;
        for (Action a : parkourability.getList()) {
            if (!a.wantsToShowStatusBar(player, parkourability)) continue;
            this.showStatus = true;
            this.statusValue = a.getStatusValue(player, parkourability);
            if (this.statusValue > 1.0f) {
                this.statusValue = 1.0f;
                break;
            }
            if (!(this.statusValue < 0.0f)) break;
            this.statusValue = 0.0f;
            break;
        }
        if (!oldShowStatus && this.showStatus) {
            this.oldStatusValue = this.statusValue;
        }
    }

    public void render(GuiGraphics graphics, Parkourability parkourability, ReadonlyStamina stamina, float partialTick) {
        float statusScale;
        Position position = new Position((Position.Horizontal)((Object)ParCoolConfig.Client.getInstance().AlignHorizontalStaminaHUD.get()), (Position.Vertical)((Object)ParCoolConfig.Client.getInstance().AlignVerticalStaminaHUD.get()), ParCoolConfig.Client.Integers.HorizontalOffsetOfStaminaHUD.get(), ParCoolConfig.Client.Integers.VerticalOffsetOfStaminaHUD.get());
        int boxWidth = 91;
        int boxHeight = 17;
        int width = graphics.guiWidth();
        int height = graphics.guiHeight();
        Tuple<Integer, Integer> pos = position.calculate(91, 17, width, height);
        float staminaScale = (float)stamina.value() / (float)stamina.max();
        float f = statusScale = this.showStatus ? MathUtil.lerp(this.oldStatusValue, this.statusValue, partialTick) : 0.0f;
        if (staminaScale < 0.0f) {
            staminaScale = 0.0f;
        }
        if (staminaScale > 1.0f) {
            staminaScale = 1.0f;
        }
        graphics.blitSprite(RenderType::guiTextured, STAMINA_EMPTY, 93, 17, 0, 0, ((Integer)pos.getA()).intValue(), ((Integer)pos.getB()).intValue(), 93, 17);
        if (!stamina.isExhausted()) {
            graphics.blitSprite(RenderType::guiTextured, STAMINA_EMPTY_CHARGE, 93, 17, 0, 0, ((Integer)pos.getA()).intValue(), ((Integer)pos.getB()).intValue(), (int)Math.ceil(92.0f * statusScale), 17);
            graphics.blitSprite(RenderType::guiTextured, STAMINA_CHARGING, 93, 17, 0, 0, ((Integer)pos.getA()).intValue(), ((Integer)pos.getB()).intValue(), Math.round(16.0f + 69.0f * this.shadowScale) + 1, 12);
            graphics.blitSprite(RenderType::guiTextured, STAMINA_FULL[this.renderGageType], 93, 17, 0, 0, ((Integer)pos.getA()).intValue(), ((Integer)pos.getB()).intValue(), Math.round(16.0f + 69.0f * staminaScale) + 1, 12);
        } else {
            graphics.blitSprite(RenderType::guiTextured, STAMINA_DEPLETED, 93, 17, 0, 0, ((Integer)pos.getA()).intValue(), ((Integer)pos.getB()).intValue(), Math.round(16.0f + 69.0f * staminaScale) + 1, 17);
        }
        this.shadowScale = staminaScale - (staminaScale - this.shadowScale) / 1.1f;
    }
}

