/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.client.hud.impl;

import com.alrex.parcool.api.Effects;
import com.alrex.parcool.common.action.Action;
import com.alrex.parcool.common.attachment.Attachments;
import com.alrex.parcool.common.attachment.common.Parkourability;
import com.alrex.parcool.common.attachment.common.ReadonlyStamina;
import com.alrex.parcool.config.ParCoolConfig;
import com.alrex.parcool.utilities.MathUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.client.event.ClientTickEvent;

public class LightStaminaHUD {
    public static final ResourceLocation STAMINA_CHARGED_MAX = ResourceLocation.fromNamespaceAndPath((String)"parcool", (String)"hud/stamina_charged_max");
    public static final ResourceLocation STAMINA_CHARGED_FULL = ResourceLocation.fromNamespaceAndPath((String)"parcool", (String)"hud/stamina_charged_full");
    public static final ResourceLocation STAMINA_CHARGED_HALF = ResourceLocation.fromNamespaceAndPath((String)"parcool", (String)"hud/stamina_charged_half");
    public static final ResourceLocation STAMINA_CHARGED_EMPTY = ResourceLocation.fromNamespaceAndPath((String)"parcool", (String)"hud/stamina_charged_empty");
    public static final ResourceLocation STAMINA_DEPLETED_FULL = ResourceLocation.fromNamespaceAndPath((String)"parcool", (String)"hud/stamina_depleted_full");
    public static final ResourceLocation STAMINA_DEPLETED_HALF = ResourceLocation.fromNamespaceAndPath((String)"parcool", (String)"hud/stamina_depleted_half");
    public static final ResourceLocation STAMINA_DEPLETED_EMPTY = ResourceLocation.fromNamespaceAndPath((String)"parcool", (String)"hud/stamina_depleted_empty");
    public static final ResourceLocation STAMINA_INFINITE_FULL = ResourceLocation.fromNamespaceAndPath((String)"parcool", (String)"hud/stamina_infinite_full");
    public static final ResourceLocation STAMINA_INFINITE_HALF = ResourceLocation.fromNamespaceAndPath((String)"parcool", (String)"hud/stamina_infinite_half");
    public static final ResourceLocation STAMINA_INFINITE_EMPTY = ResourceLocation.fromNamespaceAndPath((String)"parcool", (String)"hud/stamina_infinite_empty");
    public static final ResourceLocation STAMINA_NORMAL_FULL = ResourceLocation.fromNamespaceAndPath((String)"parcool", (String)"hud/stamina_normal_full");
    public static final ResourceLocation STAMINA_NORMAL_HALF = ResourceLocation.fromNamespaceAndPath((String)"parcool", (String)"hud/stamina_normal_half");
    public static final ResourceLocation STAMINA_NORMAL_EMPTY = ResourceLocation.fromNamespaceAndPath((String)"parcool", (String)"hud/stamina_normal_empty");
    private long lastStaminaChangedTick = 0L;
    private int lastChangingSign = 0;
    private int changingSign = 0;
    private long changingTimeTick = 0L;
    private int randomOffset = 0;
    private boolean justBecameMax = false;
    private float statusValue = 0.0f;
    private float oldStatusValue = 0.0f;
    private boolean showStatus = false;
    private int oldValue = 0;

    public void onTick(ClientTickEvent.Post event, LocalPlayer player) {
        Parkourability parkourability = Parkourability.get((Player)player);
        if (parkourability == null) {
            return;
        }
        ReadonlyStamina stamina = (ReadonlyStamina)player.getData(Attachments.STAMINA);
        int newValue = stamina.value();
        this.changingSign = (int)Math.signum(newValue - this.oldValue);
        long gameTime = player.getCommandSenderWorld().getGameTime();
        if (this.changingSign != this.lastChangingSign) {
            this.lastChangingSign = this.changingSign;
            this.changingTimeTick = 0L;
        } else {
            ++this.changingTimeTick;
        }
        this.randomOffset = player.getRandom().nextInt(5) == 0 ? (this.randomOffset += player.getRandom().nextBoolean() ? 1 : -1) : 0;
        if (newValue != this.oldValue || stamina.isExhausted()) {
            this.lastStaminaChangedTick = gameTime;
        }
        this.justBecameMax = this.oldValue < newValue && newValue == stamina.max();
        this.oldStatusValue = this.statusValue;
        boolean oldShowStatus = this.showStatus;
        this.showStatus = false;
        if (ParCoolConfig.Client.Booleans.ShowActionStatusBar.get().booleanValue()) {
            for (Action a : parkourability.getList()) {
                if (!a.wantsToShowStatusBar(player, parkourability)) continue;
                this.showStatus = true;
                this.statusValue = a.getStatusValue(player, parkourability);
                if (this.statusValue > 1.0f) {
                    this.statusValue = 1.0f;
                    break;
                }
                if (!(this.statusValue < 0.0f)) break;
                this.statusValue = 0.0f;
                break;
            }
        }
        if (!oldShowStatus && this.showStatus) {
            this.oldStatusValue = this.statusValue;
        }
        this.oldValue = newValue;
    }

    public void render(GuiGraphics graphics, Parkourability parkourability, ReadonlyStamina stamina, float partialTick) {
        long gameTime;
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        boolean inexhaustible = player.hasEffect(Effects.INEXHAUSTIBLE);
        boolean exhausted = stamina.isExhausted();
        if (!this.showStatus && (gameTime = player.level().getGameTime()) - this.lastStaminaChangedTick > 40L && !ParCoolConfig.Client.Booleans.ShowLightStaminaHUDAlways.get().booleanValue()) {
            return;
        }
        float staminaScale = (float)stamina.value() / (float)stamina.max();
        if (staminaScale < 0.0f) {
            staminaScale = 0.0f;
        }
        if (staminaScale > 1.0f) {
            staminaScale = 1.0f;
        }
        staminaScale *= 10.0f;
        float statusScale = this.showStatus ? MathUtil.lerp(this.oldStatusValue, this.statusValue, partialTick) * 10.0f : 0.0f;
        int width = graphics.guiWidth();
        int height = graphics.guiHeight();
        int baseX = width / 2 + 91 + ParCoolConfig.Client.Integers.HorizontalOffsetOfLightStaminaHUD.get();
        int baseY = height - Minecraft.getInstance().gui.rightHeight + ParCoolConfig.Client.Integers.VerticalOffsetOfLightStaminaHUD.get();
        for (int i = 0; i < 10; ++i) {
            int x = baseX - i * 8 - 9;
            int offsetY = 0;
            Type type = inexhaustible ? (this.showStatus ? (statusScale > (float)i + 0.9f ? Type.CHARGED : Type.NORMAL) : Type.INFINITE) : (exhausted ? Type.DEPLETED : (statusScale > (float)i + 0.9f ? Type.CHARGED : Type.NORMAL));
            Size size = this.justBecameMax ? Size.MAX : (staminaScale < (float)i ? Size.EMPTY : (staminaScale < (float)i + 0.5f ? Size.HALF : Size.FULL));
            if (this.justBecameMax) {
                offsetY = -1;
            } else if (this.changingSign == 1) {
                if ((this.changingTimeTick & 0x1FL) == (long)i) {
                    offsetY = -1;
                }
            } else if ((float)(i + 1) > staminaScale && staminaScale > (float)i && this.changingSign == -1) {
                offsetY = this.randomOffset;
            }
            graphics.blitSprite(RenderType::guiTextured, type.getTexture(size), 9, 9, 0, 0, x, baseY + offsetY, 9, 9);
        }
        Minecraft.getInstance().gui.rightHeight += 10;
    }

    private static enum Type {
        NORMAL(new ResourceLocation[]{STAMINA_NORMAL_EMPTY, STAMINA_NORMAL_HALF, STAMINA_NORMAL_FULL, STAMINA_CHARGED_MAX}),
        DEPLETED(new ResourceLocation[]{STAMINA_DEPLETED_EMPTY, STAMINA_DEPLETED_HALF, STAMINA_DEPLETED_FULL, STAMINA_CHARGED_MAX}),
        INFINITE(new ResourceLocation[]{STAMINA_INFINITE_EMPTY, STAMINA_INFINITE_HALF, STAMINA_INFINITE_FULL, STAMINA_CHARGED_MAX}),
        CHARGED(new ResourceLocation[]{STAMINA_CHARGED_EMPTY, STAMINA_CHARGED_HALF, STAMINA_CHARGED_FULL, STAMINA_CHARGED_MAX});

        private ResourceLocation[] list;

        private Type(ResourceLocation[] list) {
            this.list = list;
        }

        private ResourceLocation getTexture(Size size) {
            return this.list[size.ordinal()];
        }
    }

    private static enum Size {
        EMPTY,
        HALF,
        FULL,
        MAX;

    }
}

