/*
 * Decompiled with CFR 0.152.
 */
package net.hypercubemc.iris_installer.layouts;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Hashtable;

public class VerticalLayout
implements LayoutManager {
    public static final int CENTER = 0;
    public static final int RIGHT = 1;
    public static final int LEFT = 2;
    public static final int BOTH = 3;
    public static final int TOP = 1;
    public static final int BOTTOM = 2;
    private int vgap;
    private int alignment;
    private int anchor;
    private Hashtable comps;

    public VerticalLayout() {
        this(5, 0, 1);
    }

    public VerticalLayout(int vgap) {
        this(vgap, 0, 1);
    }

    public VerticalLayout(int vgap, int alignment) {
        this(vgap, alignment, 1);
    }

    public VerticalLayout(int vgap, int alignment, int anchor) {
        this.vgap = vgap;
        this.alignment = alignment;
        this.anchor = anchor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dimension layoutSize(Container parent, boolean minimum) {
        Dimension dim = new Dimension(0, 0);
        Object object = parent.getTreeLock();
        synchronized (object) {
            int n = parent.getComponentCount();
            for (int i = 0; i < n; ++i) {
                Component c = parent.getComponent(i);
                if (!c.isVisible()) continue;
                Dimension d = minimum ? c.getMinimumSize() : c.getPreferredSize();
                dim.width = Math.max(dim.width, d.width);
                dim.height += d.height;
                if (i <= 0) continue;
                dim.height += this.vgap;
            }
        }
        Insets insets = parent.getInsets();
        dim.width += insets.left + insets.right;
        dim.height += insets.top + insets.bottom + this.vgap + this.vgap;
        return dim;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container parent) {
        Insets insets = parent.getInsets();
        Object object = parent.getTreeLock();
        synchronized (object) {
            Dimension d;
            Component c;
            int i;
            int n = parent.getComponentCount();
            Dimension pd = parent.getSize();
            int y = 0;
            for (i = 0; i < n; ++i) {
                c = parent.getComponent(i);
                d = c.getPreferredSize();
                y += d.height + this.vgap;
            }
            y -= this.vgap;
            y = this.anchor == 1 ? insets.top : (this.anchor == 0 ? (pd.height - y) / 2 : pd.height - y - insets.bottom);
            for (i = 0; i < n; ++i) {
                c = parent.getComponent(i);
                d = c.getPreferredSize();
                int x = insets.left;
                int wid = d.width;
                if (this.alignment == 0) {
                    x = (pd.width - d.width) / 2;
                } else if (this.alignment == 1) {
                    x = pd.width - d.width - insets.right;
                } else if (this.alignment == 3) {
                    wid = pd.width - insets.left - insets.right;
                }
                c.setBounds(x, y, wid, d.height);
                y += d.height + this.vgap;
            }
        }
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.layoutSize(parent, false);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        return this.layoutSize(parent, false);
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    public String toString() {
        return this.getClass().getName() + "[vgap=" + this.vgap + " align=" + this.alignment + " anchor=" + this.anchor + "]";
    }
}

