/*
 * Decompiled with CFR 0.152.
 */
package net.hypercubemc.iris_installer;

import com.formdev.flatlaf.FlatDarkLaf;
import com.formdev.flatlaf.FlatLightLaf;
import java.awt.Desktop;
import java.awt.GraphicsEnvironment;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import javax.swing.JOptionPane;
import net.fabricmc.loader.api.entrypoint.PreLaunchEntrypoint;
import net.hypercubemc.iris_installer.DarkModeDetector;
import org.lwjgl.util.tinyfd.TinyFileDialogs;

public class IrisPreLaunch
implements PreLaunchEntrypoint {
    public void onPreLaunch() {
        boolean dark = DarkModeDetector.isDarkMode();
        System.setProperty("apple.awt.application.appearance", "system");
        if (dark) {
            FlatDarkLaf.setup();
        } else {
            FlatLightLaf.setup();
        }
        if (GraphicsEnvironment.isHeadless() || !IrisPreLaunch.hasAwtSupport()) {
            TinyFileDialogs.tinyfd_messageBox("Cannot launch game", "The Iris Installer is not a mod, please remove it from your mods folder and download Iris from Modrinth. (https://modrinth.com/mod/iris)", "yesno", "error", false);
        } else if (JOptionPane.showConfirmDialog(null, "The Iris Installer is not a mod, please remove it from your mods folder and download Iris from Modrinth. Would you like to launch Modrinth?", "Cannot launch game", 0) == 0) {
            try {
                IrisPreLaunch.openURL(new URI("https://modrinth.com/mod/iris"));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        System.exit(0);
    }

    public static boolean hasMacOs() {
        return System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("mac");
    }

    public static boolean openURL(URI uri) {
        if (!Desktop.isDesktopSupported()) {
            return false;
        }
        Desktop d = Desktop.getDesktop();
        if (!d.isSupported(Desktop.Action.BROWSE)) {
            return false;
        }
        try {
            d.browse(uri);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean hasAwtSupport() {
        if (IrisPreLaunch.hasMacOs()) {
            for (String key : System.getenv().keySet()) {
                if (!key.startsWith("JAVA_STARTED_ON_FIRST_THREAD_")) continue;
                return false;
            }
        }
        return true;
    }
}

